%����� Robot_rot, ������ ������ ����� ������ ��������
%������� ( handle ) �� ������, ��������������
%   ����������� "���������������� ����� �� ��������� ����"
%
%��������� ��������� ( ������ ������ ):
% forward, rot, is_bord, mark, is_mark, get_side, get_tmpr  
%
%����������� �����������, ��������� � �������� ������� ����������� ��������
%������������: 
%   ��� ������; ��������� ������; ��������� �������;
%   ���������, ���� �� ����������� ����� �� �����, �����, ������
%
%************************************************************************
%���������� �� ������ Rob_rel ���, ��� ������ ���� ������� Rob_rel\Left �
%Rob_rel\Right � ������ Rob_rot ������� ���� ���� ����� rot, �� � ����������,
%������� ����� ��������� 3 ��������: 'left', 'right', 'back' (��� 'l',
%'r','b')
%� ����� ���, ��� ����� Rob_rot\is_bord ����� ��������, ������� �����
%��������� ����� 3 ��������: 'forward', 'left', 'right'
%
%------------------------------------------------------------------------
%����: 04.09.2015
%-----------------------------------------------------------------------



classdef Robot_rot < handle
% Robot_rot - �����-�������� ������ Robot_engine( )
       
    properties( Access = private ) 
        hField % ������ �� ������ ������ Robot_engine (����� �� ��������� ����)
    end
               
    
    methods( Access = public )
       
        function obj = Robot_rot( mapfile )
            %Robot_rot - ����������� ������
            %
            %���������:
            %       r = Robot_rot()
            %       r = Robot_rot( mapfile ) 
            %
            %� 1-�� ������ ���������� ����������� ���������� ���� ��� 
            %������ �����, � ������ ������, ����������� ������ ���
            %����������� ���������� ����
            %
            %�� 2-� ������:
            % - mapfile - ��� �����, � ������� ��������� ���������� �� ����
            %
            %���������:
            % - r = ������ ( handle ) �� ��������� ������ ������ Rob_rot
            %
            %-------------------------------------------------------------
            % ��������� ��������� ������ ( ������ ������ ):
            %   forward, rot, is_bord, mark, is_mark, get_side, get_tmpr  
            %
            %-------------------------------------------------------------
            %�������� ( ���������� ��� ��������������� ) ��������� ���������� 
            %�� ���� ����� � ������� ����:
            %  -���� �� ������ ������������� ������
            %  -���� �� ������� ������� ������
            %  -���� �� ���������� ����� ����� ���������� ���� �������������
            %  �����������
            %  -���� �� ����������� ������� �����������
            %  -���� �� ������ � ����������� ���� ��� ������������ �������
            %  ���������� ������ ����� �� �������� � ������ ������
            %  ( "������������" ������ ����� ����� "��������" ����� �������� )
            %����� ������ ����� ����� �������� ����� ����� ����� � ���������� 
            %����������
            %
            %-------------------------------------------------------------
            %��������� ��������� ������� �������������� ���������� �� ���� 
            %����� � ������� ���������� ������ CTRL+S 
            %( ��� ���� ���� � ������� ������ ���� �������! )
            %
            %������������ ��������� ����������� ���������� �� ���� ����� � ������� 
            %���������� ������ CTRL+R ( ��� ���� ���� � ������� ������ ���� �������! )
            %
            %����������� �������� ���������� ������ ����� � ������� ���������� ������
            %CRTL+T ( ��� ���� ���� � ������� ������ ���� �������! )
            %��������� ������� ���� ���������� ������ ������� �������� ���������� ��
            %������
            %����������������� �������� ���������� ����� ������������� ( ���������� ��������������
            %����������� ������ � ������������ ������, ��� ���������� �� �����
            %��������� CTRL+S )
            %
            %����������� ������ ����� �������� ���������� ������ ������ ������ � �������
            %���������� ������ CTRL+"����" ��� CTRL+"�����", ��������������            
            %( ��� ���� ���� � ������� ������ ���� �������! )
            
            if nargin == 0
                mapfile = [];
            end
            
            obj.hField = Robot_engine( mapfile, 'ort' );
                        
#            if ~isvalid( obj.hField )
#                % ���� �� �������                
#                delete( obj )
#            else
                set( obj.hField.hFig, 'userdata', obj ) %����� ����� ���� ������� ������ ��� �������� ���� ( ��. rob_objct_delete )
#            end
                                             
         end % function obj = Robot_rot 
        

        
        
        function forward( obj )
            %forward - ������� ����������� ������ ������ � �������� ������ 
            % 
            %���������:
            %           r.forward( )
            %
            %����:            
            % - r = ������ �� ������ ������ Robot_rot:
            %   ����� � �������� ������ ����, ����� �� ����� ������ 
            %   ����������� ���
            %
            %���������:
            % - ����� � �������� �� ����������� side ������ ( ����
            %   ������ �� ���� ������ ��� �����������, � ��������� ������ 
            %   ���������� "�������" ������ )

          
#           if ~isvalid( obj )
#                % ��� ��������, � ������ ������ ������������ ������� ���� � ��������������� �������
#                error '���� � ������� �����������'                
#            end
            
            if numel( obj ) ~= 1
                error '������� step ��������� ������ � ������ ���������� ������ ( � ������� ������ Rob_rot �� 1-�� �������� )'
            end
            
            if is_star_to_end( obj.hField.hFig ) == 1
                error '����� �� ����� � ������. ��������� ��������� ��������� ������� �������������� ���������� �� ���� ��������� ���������� CTRL+S (��� �������� ���� � �������) ��� ������������ �������� ���������� �������� CTRL+R'
            end
             
            side = obj.hField.get_side_();
            
            coderror = obj.hField.step( side );
            
            switch coderror
                case 3
                    error '����� ������� �� ����'
                case 4
                    error '�������� ��������� ������ ���� ''n'' | ''s'' | ''o'' | ''w'''                    
                case 5
                    error '��������� ������: ����� ������ �� ���������'                    
            end

        end % function forward
        
 
        
        function rot( obj, side )
            %rot - ������� ���������� ������ ������, ������� ��� ����� 
            % 
            %���������:
            %           r.rot( side )
            %
            %����:            
            % - r = ������ �� ������ ������ Rob_rot:
            %   ����� � �������� ������ ����
            % - side = 'l' ('left') | 'r' ('right') | 'b' ('back') 
            %���������:
            % - ����� ��������� ����� �� 90 ��������
            
            if is_star_to_end( obj.hField.hFig ) == 1
                error '����� �� ����� � ������. ��������� ��������� ��������� ������� �������������� ���������� �� ���� ��������� ���������� CTRL+S (��� �������� ���� � �������) ��� ������������ �������� ���������� �������� CTRL+R'
            end
                                    
            coderror = obj.hField.rot( side );
            
            switch coderror
                case 3
                    error '����� ������� �� ����'
                case 4
                    error '�� ��������������� �������� ���������'
            end
            
        end
        
                
        
        
        function   ansv = is_bord( obj, side )
            %is_bord - ������� ��������� ������� ����������� � �������� �����������
            %
            %���������:
            %          ansv = r.is_bord( side )
            %
            %����:
            % - r = ������ �� ������ ������ Robot_rot:
            %   ����� � �������� ������ ����
            % - side = 'forward' ('f') | 'left' ('l') | 'right' ('r') 
            %
            %���������:
            % - ansv = 1 ( true ), e��� � ����������� side ���� �����������  
            %        = 0 ( false ) - � ��������� ������ 
            
#            if ~isvalid( obj )
#                % ��� ��������, � ������ ������ ������� ���� � ��������������� �������
#                error '���� � ������� �� �������'                
#            end
                        
            if numel( obj ) ~= 1
                error '������� is_bord ��������� ������ � ������ ���������� ������ ( � ������� ������ RobAbs �� 1-�� �������� )'
            end
            
            if is_star_to_end( obj.hField.hFig ) == 1
                error '����� �� ����� � ������. ��������� ��������� ��������� ������� �������������� ���������� �� ���� ��������� ���������� CTRL+S (��� �������� ���� � �������) ��� ������������ �������� ���������� �������� CTRL+R'
            end
            
            absSide = obj.hField.get_side_();
            
            absSide = cod_side( absSide );
            switch upper( side )
                case {'LEFT', 'L'}
                    absSide = mod( absSide - 1, 4);    
                case {'RIGHT','R'}
                    absSide = mod( absSide + 1, 4);
                case {'FORWARD', 'F'}
                    %����������� �������� �������
                otherwise
                    error '������� �������� ������ ����� �������� ''forward'' (''f'') |''left'' (''l'') | ''right'' (''r'')'
            end
            absSide = decod_side( absSide );
            
            [ansv, coderror] = obj.hField.is_bord( absSide );

            switch coderror
                case 3
                    error '����� ������� �� ����'
                case 4
                    error '�������� ��������� ������ ���� ''n'' | ''s'' | ''o'' | ''w'''                    
            end
             
        end % function   ansv = is_bord

        
        
        
        function mark( obj )
            %mark - ������� ��������� ������ � ������ � �������
            %
            %���������:
            %           r.mark()
            %
            %����:
            % - r = ������ �� ������ ������ Robot_rot:
            %   ����� � �������� ������ ����
            %   
            %���������:
            % -  � ������ � ������� ����� ������ 
            %( ��������� ��������� ������ �� ��������, ����� ��� ������������ ������ ������ )
            
#            if ~isvalid( obj )
#                % ��� ��������, � ������ ������ ������� ���� � ��������������� �������
#                error '���� � ������� �� �������'                
#            end

            if numel( obj ) ~= 1
                error '������� mark ��������� ������ � ������ ���������� ������ ( � ������� ������ RobAbs �� 1-�� �������� )'
            end
            
            if is_star_to_end( obj.hField.hFig ) == 1
                error '����� �� ����� � ������. ��������� ��������� ��������� ������� �������������� ���������� �� ���� ��������� ���������� CTRL+S (��� �������� ���� � �������) ��� ������������ �������� ���������� �������� CTRL+R'
            end
            
            coderror = obj.hField.mark();
            
            switch coderror
                case 3
                    error '����� ������� �� ����'
            end            
        end % function mark
        
        
        
        function ansv = is_mark( obj )
            %is_mark - ������� ��������� ������� ������� ������ ����
            %
            %���������:
            %            ansv = r.is_mark()
            %
            %����:
            % - r = ������ �� ������ ������ Robot_rot:
            %   ����� � �������� ������
            %
            %���������:
            % - ansv = 1 ( true ), e��� � ������ � ������� ����� ������  
            %        = 0 ( false  ) - � ��������� ������ 
            
#            if ~isvalid( obj )
#                % ��� ��������, � ������ ������ ������� ���� � ��������������� �������
#                error '���� � ������� �� �������'                
#            end
            
            if numel( obj ) ~= 1
                error '������� is_mark ��������� ������ � ������ ���������� ������ ( � ������� ������ RobAbs �� 1-�� �������� )'
            end

            if is_star_to_end( obj.hField.hFig ) == 1
                error '����� �� ����� � ������. ��������� ��������� ��������� ������� �������������� ���������� �� ���� ��������� ���������� CTRL+S (��� �������� ���� � �������) ��� ������������ �������� ���������� �������� CTRL+R'
            end

            [ansv, coderror] = obj.hField.is_mark();
            switch coderror
                case 3
                    error '����� ������� �� ����'
            end   
            
        end % function ansv = is_mark
        
        
        
        function val = get_tmpr( obj )
            %get_tmpr - ������� �������� � �������� "�����������" ������� ������
            %
            %���������:
            %            val = r.get_tmpr()
            %
            %����:
            % - r = ������ �� ������ ������ Robot_rot:
            %   ����� � �������� ������
            %
            %���������:
            % - val = ����� ����� ( double ) = "�����������" ������ � �������
            %
            % ( ��� �������� ������ ������� ������ Robot_rot, "�������������"
            % ���� ����������� ��������, �� ��� �������� ����� ����������
            % ������� �� ����� - ��� ������� )
        
#            if ~isvalid( obj )
#                % ��� ��������, � ������ ������ ������� ���� � ��������������� �������
#                error '���� � ������� �� �������'
#            end    
            
            if numel( obj ) ~= 1
                error '������� get_tmpr ��������� ������ � ������ ���������� ������ ( � ������� ������ RobAbs �� 1-�� �������� )'
            end
            
            if is_star_to_end( obj.hField.hFig ) == 1
                error '����� �� ����� � ������. ��������� ��������� ��������� ������� �������������� ���������� �� ���� ��������� ���������� CTRL+S (��� �������� ���� � �������) ��� ������������ �������� ���������� �������� CTRL+R'
            end
            
            [val, coderror] = obj.hField.get_tmpr();

            switch coderror
                case 3
                    error '����� ������� �� ����'
            end
            
        end % function val = get_tmpr
        
        
        function side = get_side( obj )
            %get_side - ������� �������� ������� ����������� ������
            %
            %���������:
            %            side = r.get_side()
            %
            %����:
            % - r = ������ �� ������ ������ Robot_rot:
            %   ����� � �������� ������
            %
            %���������:
            % - side = 'n' (�����) | 's' (��) | 'o' (������) | 'w' (�����)
            %   - ������� ����������� ������
            % 

#            if ~isvalid( obj )
#                % ��� ��������, � ������ ������ ������� ���� � ��������������� �������
#                error '���� � ������� �� �������'
#            end
            
            if numel( obj ) ~= 1
                error '������� get_side ��������� ������ � ������ ���������� ������ ( � ������� ������ Rob_rot �� 1-�� �������� )'
            end
            
            if is_star_to_end( obj.hField.hFig ) == 1
                error '����� �� ����� � ������. ��������� ��������� ��������� ������� �������������� ���������� �� ���� ��������� ���������� CTRL+S (��� �������� ���� � �������) ��� ������������ �������� ���������� �������� CTRL+R'
            end
            
            [side, coderror] = obj.hField.get_side();
            
            switch coderror
                case 3
                    error '����� ������� �� ����'
            end
            
        end % function side = get_side
        
    end % methods public
        
end % classdef Robot_rot
