        function  obj = field_create( obj, fSize )
            %������� ���� � ���������� �������� ������������ ������� obj
            %
            %���������:           
            %    obj = field( obj ... )
            %    field( obj, fSize ) 
            %                          ( fSize - �� ������ ������! )
            %
            %�������:
            % - obj - ������ ������ Robot_engine ( ��� �� ��������������
            % ������������ !!! )
            %
            %   ��� ����, ���� ������� 3 ����������� ��������� (������� obj), �� ����������� ��� 
            %   �������������� � ������������ ������������� ������������ ����, � ����
            %   ������� 4 ����������� ���������, �� ��������� ����� ����
            %
            % - [fSize = 2-������ double = ����� ����� � ��������
            % ���������� ���� ]
            % 
            %���������:
            % - ���������������� �������� ������� obj
            % - ���� ������� ������ 3 ������� ���������, �� ����������� ������������� �� 
            % ���������� 'r' ���������������� mat-����� � ������������ � ����������� ����������� ����; 
            % ��� ������������ ����� ��� ������� ��������������� � ������������� � �����
            % 
            % - ���� ������� ��� 4 ������� ���������, �� ������������ ��������� ������
            %
            % ��� �������������� ����� � �������������, ����� ������ ����������� ������ ��� 
            % ������ �����.
            %            
            % ��� �������� ���� � ��������� ����� �������� ��������, ��������� 
            % ��������� ������ - ����� ������ ����. � ������� ���� ������ ����� ���������� 
            % � ����� ������ ������, ��������� ������������ ��������������� ������ � 
            % ����������� ����������� ����� �������� ����� �������������� � ������� ����.                                    
#Date: 11.09.2015
            flag_framework_create = 0;
            if nargout == 0
                # это для случая, когда изменяются размеры поля
                obj.hRobot = [];
                #see lines 225...255 (242)
                obj.hFramework = []; 
                # - это что бы framework_create могла выполниться 
                flag_framework_create = 1;
                # - новое поле ВСЕГДА создается с рамкой
            end
           
            if nargin == 1 
                
                if nargout == 0
                    error '��������� ������� ������������ ��������� ���������'
                end
                
#                if ischar( name )
                    load( obj.fName, 'r', '-mat' )  

                    if ~( isequal( obj.fhBody, @Body1 ) || isequal( obj.fhBody, @Body4 ) )
                        delete( obj.hFig )

                        error '�������� ������ ����� �������� @Body1 ��� @Body4' 
                    end
                    
                    obj = r; % - ����� ����� ������������ obj - ��� �� ������ �� �������� ������ !!!
                             % ������� � ��������� ����������� �������� ��������           
#                else
#                    delete( obj.hFig )
#                    error '��������� ��������� ������ ���� ������ char'
#                end
                
            elseif nargin == 2  
                
                if numel( fSize ) ~= 2
                    error '������ ���� ������ ���� ����� ����� ( ������ �������������� ) ����������'
                end
                obj.size = fSize; %[m, n];
                              
                obj.hMark = cell( fSize );     
                obj.hVerBord = cell( fSize(1), fSize(2)-1 ); 
                obj.hHorBord = cell( fSize(1)-1, fSize(2) ); 

                % ��� ������� ������������� ��� ������������ �.�.
                % 0 - ����� ���������������� ��� ���������� ����������� �.�.

                obj.tMap = round( randn( fSize )*10 );

            %    obj.allHandles = []; 
            else
                error '����� ������� ���������� ������ ���� ����� 3 ��� 4'
            end
             
 
            [ ~, filename, fext] = fileparts( obj.fName ); 
            
            obj.hFig = figure(...
                'name'    , ['Robot - ',filename, fext],...
                'numbertitle', 'on',...
                'menubar' , 'none' ,...
                'position', [0.5 1.5 obj.size(2) obj.size(1)]*obj.diametr,...
                'resize'  , 'off',...
                'WindowKeyPressFcn', { @window_key_press, obj },... % ��� �����, ��������� obj - ��� ������!!!
                'WindowButtonMotionFcn', { @window_button_motion, obj },...
                'WindowButtonUpFcn', { @window_button_up, obj },...                
                'WindowButtonDownFcn',{ @window_button_down, obj }... 
                );
#               'ButtonDownFcn', { @button_down_to_cage, obj },... 
           
            set( obj.hFig, 'DeleteFcn', {@rob_object_delete, obj} );
            
            
            #####################################
            load load_icon load_icon '-mat'
            
            obj.hLoadTool = uipushtool(...
              'cdata', load_icon,...
              'tooltipstring','Load',...
              'enable', 'off',...
              'clickedcallback', @load_tool...
              );
            
            
            load save_icon save_icon
            
            obj.hSaveTool = uipushtool(...
              'cdata',save_icon,...
              'tooltipstring','Save',...
              'enable', 'off',...
              'clickedcallback', @save_tool...
              );
              
            load restore_icon restore_icon  
            obj.hRestoreTool = uipushtool(...
              'cdata', restore_icon,...
              'tooltipstring','Restore',...
              'enable', 'off',...
              'clickedcallback', {@restore_tool, obj}...
              );
              
            load delay_icon delay_icon  
            obj.hAddDelayTool = uitoggletool(...
              'cdata', delay_icon,...
              'tooltipstring','Add delay ON/OFF',...
              'state', 'on',...
              'clickedcallback', {@delay_tool, obj}...
              );
            
          
             
            load show_values_icon show_values_icon 
            obj.hShowValuesTool = uitoggletool(...
              'cdata', show_values_icon,...
              'tooltipstring','Show values ON/OFF',...
              'state', 'off',...
              'clickedcallback', {@values_tool, obj}...
              );
              
              
            load frame_icon frame_icon 
            obj.hFrameworkTool = uitoggletool(...
              'cdata', frame_icon,...
              'tooltipstring','External framework ON/OFF',...
              'state', 'on', ...
              'clickedcallback', {@framework_tool, obj},...
              'enable', 'on'...
              );#      
#в принципе тут state = on / off - это могло бы зависеть от содержимого mapfile
#но принятое решение о том, что при загрузке рамка всегда есть, видится более гибким и легче 
#реализуемым (рамку легко убрать, простым нажатием кнопки)            
            
#Редактировать размеры поля должно быть возможно ВСЕГДА,
# только в случае, если была загружена ранее созданная обстановка,
# то при редактировании размеров поля она просто исчезнет
            load height_plus_icon height_plus_icon
            obj.hHeightPlusTool = uipushtool(...
              'cdata', height_plus_icon,...
              'tooltipstring','To reduce height',...
              'enable', 'on', ...
              'clickedcallback', {@height_plus_tool, obj}...
              );   
              
            load height_minus_icon height_minus_icon 
            obj.hHeightMinusTool = uipushtool(...
              'cdata', height_minus_icon,...
              'tooltipstring','To increase height',...
              'enable', 'on', ...
              'clickedcallback', {@height_minus_tool, obj} ...
              ); 
            
            
            load width_plus_icon width_plus_icon
            obj.hWidthPlusTool = uipushtool(...
              'cdata', width_plus_icon,...
              'tooltipstring','To reduce width',...
              'enable', 'on', ...
              'clickedcallback', {@width_plus_tool, obj}...
              );    
              
              
            load width_minus_icon width_minus_icon  
            obj.hWidthMinusTool = uipushtool(...
               'cdata', width_minus_icon,...
              'tooltipstring','To increase width',...
              'enable', 'on', ...
              'clickedcallback', {@width_minus_tool, obj}...
              ); 
 
%            load rob_type_4_icon rob_type_4_icon 
% 
%            obj.hRobotTypeTool = uipushtool(...
%              'cdata', rob_type_4_icon,...            
%              'tooltipstring','Choice of type of the robot', ...
%              'enable', 'off', ...
%              'clickedcallback', {@robot_type_tool, obj}...
%              ); 
              
              
            load help_icon help_icon 
            obj.hHelpTool = uipushtool(...
              'cdata', help_icon,...
              'tooltipstring','Help', ...
              'enable', 'off', ...              
              'clickedcallback', {@help_tool, obj}...
              );
 

            ######################################
            
            obj.hAxes = axes(...
                'units', 'normalize',...
                'ButtonDownFcn', { @button_down_to_cage, obj },...            
                'position', [0, 0, 1, 1],...
                'xlim'    , [0 obj.size(2)],...
                'ylim'    , [0 obj.size(1)],...
                'visible' , 'off'...
                );
                
######
            if isempty(obj.hFramework) == 1 || flag_framework_create == 1 
#При изменении размера поля придется его создавать заново, поэтому требуется эта проверка
#НО Тут, м.б., надо еще согласовать с значением свойства кнопки state on/off
                framework_create(obj)
                % ���������� �������������� ���� �����
            end
######          
            grid_create(obj)

%...................................................................            
            if isempty( obj.hRobot )
                % ����������� ������ (�����) ������ ���� ������ ������
                % ( �� �� ������ ���� ������������ )
                
                if isequal( obj.fhBody, @Body4 )
                    obj.hRobot = Body4( [0, 0], obj.hFig );
                elseif isequal( obj.fhBody, @Body1 )
                    if isempty( obj.hRobot )
                        side = 0;
                    else
                        side = obj.hRobot.side;
                    end
                    
                    obj.hRobot = Body1( [0, 0], obj.hFig, side );
                else
                    error '�������� ������ ����� �������� @Body1 ��� @Body4' 
                end
                
                add_star_to_end( gcf );
            else
                % ����������� ������ (�����) ������ ���� ������������
                
                obj.hRobot = obj.fhBody( r.hRobot, obj.hFig );
                % ������ ����������� ����� (�����), ��� ���� ������� ��� ������ �����
                % ���� ������������, � ������������ �� ���������
                % ��������� obj.fhBody ( - ��� ���������� ���������������� ������������ )
                    
                r = obj;
                save( obj.fName, 'r', '-mat' )
                % - ��� ���������, ���� ��� ������ ��� �������
            end
            %....................................................................

            if exist( 'r', 'var' ) == 1
                % ������ r ( ������ Rob_??? ) ��� ��������
                obj.bord_rest()
                obj.mark_rest()
            end

            % set( hfig, 'window_key_pressFcn', { @save, name, obj })
            
            set( obj.hFig, 'HandleVisibility' , 'callback' ) % ��������� ��������� ����� ����������� ������ � ���� (� ������������ ���� ����)
 
            set(gca,'userdata', obj ) 
            # - добавлено в версии для октавы, для функции Control/delete_marker 
                      
            
        end % function field_create
        
        
                
        function grid_create( obj )
            %������� ( � ������������ ���� ) ����� �� ���������� �����
            
            axis( 'equal', [0, obj.size(2), 0, obj.size(1)] )
            
            M = obj.size(1);               
            N = obj.size(2);

            for y = 0:M 
                h = line(...
                      'xdata'        , [0 N],...
                      'ydata'        , [y y],...
                      'linestyle'    , ':',...
                      'color'        , 'b',...
                      'ButtonDownFcn', { @button_down_to_grid, 'hor', obj }...
                      );
            %    obj.allHandles(end+1) = h;      
            end
            %! ��������� �������������� ���������� �����

            for x = 0:N 
                h = line (...
                      'xdata'        , [x x],...
                      'ydata'        , [0 M],...
                      'linestyle'    , ':'  ,...
                      'color'        , 'b'  ,...
                      'ButtonDownFcn', { @button_down_to_grid, 'ver', obj }...                      
                      );
            %    obj.allHandles(end+1) = h;      
            end
            %! ��������� ������������ ���������� �����

        end % function grid_create

