%Body - ����������� ����� ��� ����������� ������������� ��������� �� ����������������
%������ ( < handle )
%
%Public - ������:
%   shift, mark, is_mark, is_bord, meas
%Protected - ������:
%   sond_data_init ( ����������� ����� )
%
%��������:
% position, delay, moved
%-------------------------------------------------------------------------
%����: 27.08.2015
%-----------------------------------------------------------------------


classdef Body < handle


    properties (Access = public)
        
        position % �������  ������  ����, ���������� ������ ( ����� ������ ������ �������������: [1,1] )
        
#        delay % = Robot.Options.delay %????? ���� �� ��� ��������� �� mat-�����
        moved % = 'off' % ����, ������������ ����������� ���������� ������ �����
        
    end
       
    
    properties( Access =  public ) %protected -для ОКТАВы пришлось доступ открытым
        
        hCorp % ���������� ������� 
        hL    % = 4-������ ������������ ����� ������:
        %          1-�� ����� - �������� ��� ��������
        %          2-�� ����� - ������   ��� ���������
        %          3-�� ����� - ������   ��� �����
        %          4-�� ����� - �����    ��� ���������
                
        % ������ ������������� ������ ������ � ��������� ������ � ������ ���������
        % ( ���������� ������ ������  = (0,0) ):
        xData_0_corp
        yData_0_corp
       
        xData_0_L % = cell(1,4)
        yData_0_L % = cell(1,4)
        
        R % = 0.35 % ������ �������
        L % = 0.15 % ������� ������ ����� ( ��������, - ������� ��������, ���� ����� ���������� )
        
        hFig
    end
    
    
    methods( Access = public )
        
        function r = Body( coordinates, hFig )
            %����������� ���������������� ������ � ��� ������������ ������
            %
            %���������:
            %       r = Body( coordinates )
            % - coordinates = [x, y]  - ��������� ���������� ������ ������� ���� ������
            % - hFig = ���������� ������������ ���� ������ 
            
            r.moved = 'off';
            r.xData_0_L = cell(1,4);
            r.yData_0_L = cell(1,4);
            r.R = 0.35;
            r.L = 0.15;  
  
            r.hFig = hFig;
            r.position = fliplr( coordinates ) + 1;
            
            x = coordinates(1);
            y = coordinates(2);
                
            x_0 = x + 0.5;
            y_0 = y + 0.5;
            % x_0, y_0 - ���������� ������ ������
            
            complexData = r.R * exp( 2i*(0:0.5e-2:1)*pi );
            r.xData_0_corp = real( complexData );
            r.yData_0_corp = imag( complexData );
            
            
            r.hCorp = patch(...
                'xdata', r.xData_0_corp + x_0,...
                'ydata', r.yData_0_corp + y_0,...
                'facecolor', 'y',...
                'edgecolor', 'k',...
                'LineWidth', 1, ...
                'ButtonDownFcn', { @clic_to_corp, r }...
                );
      
            r.sond_data_init()
            % ������� ������� ������ ��� ����� ������, ����� ��������
            % ��������� � ������ ���������
            
            for i = 1:4            
                r.hL(i) = patch(...
                    'xdata', r.xData_0_L{i} + x_0,...
                    'ydata', r.yData_0_L{i} + y_0,...
                    'facecolor', 'k',...
                    'edgecolor', 'k'...
                    );          
            end
            % ��������� ����������� ������ ����� ������ � ��� �����������
            % ��������� ( � ������� � ����� ( x_0, y_0 )

######################            
%            try 
%                load('delay.mat','delay')
%            catch
%                delay = 0.1;
%                save('delay.mat','delay')
%            end
%            r.delay = delay;
######################
            
        end % function r = Body
 
        
        function Delete( r )
%r.isvalid()   
            delete( [r.hCorp, r.hL] )            
            r.delete()
        end
        
        
##################################
%ДЛЯ ОКТЫВЫ пришлось этот метод сделать обычной функцией        
%        function clic_to_corp( hCorp, eventdata, r )
%            r.moved = 'on';
%        end
#################################        
               
        
        function shift( r, coord, mode, delay )
            %��� �������� �������� ����������� ������ �� ������ coord ��� � ����� coord 
            % - � ����������� �� �������� ��������� mode
            %
            % - coord = 2-������ double = ���������� ������� ����������� | ���������� ������ ������� 
            % - mode = 'vector' (��� ������������ �����������) | 'punct'(��� ������� �����������)
            %��������� ���� ��������� ���������� (��������� * � ����� �����
            %��������� ����)
			      if nargin == 4
                pause( delay )
            end
            
            switch mode
                
                case 'vector'
                    
                    dx = coord(1);
                    dy = coord(2);
                    
                    set( r.hCorp, 'xdata', get( r.hCorp, 'xdata' ) + dx );
                    set( r.hCorp, 'ydata', get( r.hCorp, 'ydata' ) + dy );
                    
                    for i = 1:4
                        set( r.hL(i), 'xdata', get( r.hL(i), 'xdata' ) + dx ); 
                        set( r.hL(i), 'ydata', get( r.hL(i), 'ydata' ) + dy ); 
                    end
                    
                    r.position = r.position + fliplr( coord );
                                        
                case 'punct'
                    
                    x = coord(1);
                    y = coord(2);

                    set( r.hCorp, 'xdata', r.xData_0_corp + x );
                    set( r.hCorp, 'ydata', r.yData_0_corp + y );
                    
                    for i = 1:4
                        set( r.hL(i), 'xdata', r.xData_0_L{i} + x ); 
                        set( r.hL(i), 'ydata', r.yData_0_L{i} + y ); 
                    end
                    
                    r.position = fliplr( coord ) + 0.5;                   
                otherwise
                    error '����������������� �������� ���������'
            end % switch mode                                                        

% disp( r.robotPosition )

        end % function shift

        
        %----------------------------------
        function meas( r, delay )
        % ������������� ���� ���������
        % � ������������� ��������� ���������
                                
            clr = get( r.hCorp, 'edgecolor' );
            set( r.hCorp, 'edgecolor', 'g' );
            pause( delay )
            set( r.hCorp, 'edgecolor', clr );
        end % function meas
        
        
        
        function mark( r, delay )
            %������������� ���� ����������
            % � ������������� ��������� ���������
            %���� ����� ����� �������������� ����������, �� ��������� ������
            %��� ���������� ���������� �������������� � ������� * � �����
            %����� ����
                    
%            Robot_Control.SaveDialog( r.hFig )                     
            
            clr = get( r.hCorp, 'edgecolor' );
            set( r.hCorp, 'edgecolor', 'm' );
            pause( delay )
            set( r.hCorp, 'edgecolor', clr );
            
        end
        
        
        
        %----------------------------------
        function is_mark( r, delay )
        %������������� ���� ��������
        % � ������������� ��������� ���������
                    
            clr = get( r.hL(1), 'facecolor' );
            set( r.hL, 'facecolor', 'm' );
            pause( delay )
            set( r.hL, 'facecolor', clr );
        end % function is_mark
        
        
        %----------------------------------------
        function is_bord( r, side, delay )
        %������������� ���� ��������
        % � ������������� ��������� ���������


            switch side
                case {'n', 'N'}
                    i = 1;
                case {'s', 'S'}
                    i = 3; % H = r.hS;
                case {'w', 'W'}
                    i = 2; %H = r.hW;
                case {'o', 'O'}
                    i = 4; %H =  r.hO;
                otherwise
                    error '�� ���������� �������� �������� ���������'
            end % switch side
            
            clr = get( r.hL(i), 'facecolor' );
            set( r.hL(i), 'facecolor', 'g' );            
            pause( delay )
            set( r.hL(i), 'facecolor', clr );
        end % function is_bord
        
    end % methods public
    
    
    methods( Access = protected )
        function sond_data_init( obj )
            %����������� �����
        end
    end
    
end % classdef
     
