%����� Turtle < handle
%
%������ ������: 
%   forward, rot, draw, transform, set, disp ( + ������ ����������� handle )
%
%
%-------------------------------------------------------------------------
%������: 1.0*
%����: 17.03.2013



classdef Turtle < handle
    
    properties( Access = private )
        ort   %= 1 + 0i % = ������ (���������� �����), ������������ ����������� ��������
        anglE %= pi/2   % = ���������� �������� ���� �������� ��������
        pero
    end
    
    
    
   
    methods( Access = public )
        
        function obj = Turtle( x, y )
            %Turtle - ����������� ������
            %
            %���������:
            %           obj = Turtle( x, y );
            %
            %����:
            % - x, y = ���������� ���������� ��������� �������� = ������� double 
            %
            % ������������� ���������� ����� �������� ������ ���� �����, � ����������  
            % ��� ���������� ����� �������� ��� ���������� ������� forward, draw
            %
            %����:
            % - obj = ������ ( < handle ) �� ������ ������ Turtle
            % - ���������� ����� ������� obj �������� ���������� ���������� 
            % ��������� ��������
            %--------------------------------------------------------------
            %
            % ������ Turtle ����� ���������� �����.
            % ��� ������� ������, ������ 1, ���������� ����
            % ������������� �������� � ���������� �������. ��� ����
            % �������� � ������� ��� ������ ������� draw � Transform ��
            % �������� ( ������� �� ���������� �������� � ������ ).
            % 
            % ��� ������� ������, ������� 1, ��� ������������ ���� (� ������� 
            % ������� Forvard, Punct, Vector) ����� ����� ������� �������� �������������
            % � ���, �� �� ������������ � ������������ ����.
            % ��� ��������� �������, � ���� ������, ���������� ���������, ����� draw
            % ( ����� ����� � ������ ����������� ������ ��������� ����� ).            
            %
            % �����, ���� ������ ������ ������ 1, �� ��� ������������ ������, ��� ������ 
            % ������������� ������������� ( �� �������� ���������������
            % ������� ������ ) 
            %
            % �������� ������ ������ ����� � ������� ������ set.
               
            obj.ort   = 1 + 0i; % = ������ (���������� �����), ������������ ����������� ��������
            obj.anglE = pi/2;   % = ���������� �������� ���� �������� ��������
      
      
            obj.pero = Pero( x, y );
        end % function Turtle
        
        
        
        function rot( obj, side )
            %rot - ������������� �������� �� ������������� ���� � �������� �����������
            %
            %���������:
            %           obj.rot( angle )
            %����:
            % - obj = ������ �� ��������� ������ ������ Turtle
            % - side = ����������� �������� = ( L | LEFT ) | ( R | RIGHT ) (������ �������� �� �����)
            % 
            %����:
            % - �������� �������� �� ������������� ���� � ��������
            % ����������� (�������� ���� ����� ���������� � ������� ������
            % set, ���������� ���� ����� 90 ����.)
            
            if numel( obj ) ~= 1
                error '����� rot ������ Turtle ����� ����������� ������ � ���������� �������'
            end
            
            side = upper( side );
            
            switch side
                case {'L', 'LEFT'}
                    obj.ort = obj.ort * exp( 1i * obj.anglE );
                case {'R', 'RIGTH'}
                    obj.ort = obj.ort * exp( -1i * obj.anglE );
                otherwise
                    error '�� ��������������� �������� �������� ���������'
            end
        end % function rot
        
        
        
        function forward( obj )
            %forward - ���������� �������� ����� �������������� ����������� �� ������������� ���
            %
            %��������C:  
            %           obj.forward()
            %����: 
            % - obj = ������ �� ��������� ������ ������ Turtle
            %����: 
            % - �������� "�������������" ������ �� ������������� ��� 
            %   (�������� �������� ���� ����� �������� ������ set);
            % - ����� ����� ������� ��������� � ����� ( �� �� ���������� �
            % ������������ ����), ���� ������������� ������ ������ ����� 1,
            % ��� ��������� ��������������� � �������, ���� ������ ������
            % ����� 1

            if numel( obj ) ~= 1
                error '����� forward ������ Turtle ����� ����������� ������ � ���������� �������'
            end
            
            obj.pero.vector( real( obj.ort ), imag( obj.ort ))
        end % function forward
                   
        
        
        function h = draw( obj, type )
            %draw - ������ ����� ��� ����������� ������� ( ��� ��
            %��������� ), ���������� ����� ������� ���������� �� ���������� ������
            %
            %���������:
            %           obj.draw()
            %           obj.draw( type )            
            %       h = obj.draw();   
            %       h = obj.draw( type );   
            %
            %����:            
            % - obj = ��������� ������ ������ Pero
            % - ���������� ������ ����������� ������ ������ 1            
            % - ���������� ����� �������� ������������������ ��������� ����� ����� 
            % - type = 'line' | 'patch'
            % ( �� ��������� type = 'line' )
            %
            %����:
            % - � ������� ������������ ���� ��������� ����� 
            % � ����������������� ���������� 
            % ( ��������� ���������������� ������� ����� ���� ������������ � ������� ������ set )
            % 
            % - h = ���������� ����������� �����
            % - ���������� ����� �������� ������ ��������� ����� �� ��������
            % ������������������ ����� ( = ���������� �������� ��������� ���� )
            % - ���������� ����� ��������� � �������������� ������������ ��������� 
            % ��������� �� ����������������� ��������
            % ( �� ��������� �������� �������� ����������� ������ 0, ��������
            % ��� ��������� ����� � ������� ������ Set )
            %
            
            if nargout == 0
                obj.pero.draw( );
            elseif nargout == 1
                h = obj.pero.draw( type );
            else
                error '����� ����������� �������� ���������� �� ����� ���� ������ 1'
            end
            
        end
        
        
        
        function transform( obj, f, varargin )
            %transform - ��������� �������������� ��������� �����, ���������� � ������, �� ��������� ������
            %
            %���������:
            %           obj.transform( f )
            %           obj.transform( f, p1,...,pn )
            %
            %����:
            % - obj = ��������� ������ ������ Pero
            % - ���������� ������ ����������� ������ ������ 1
            % - f = ������ �� ������� (function_handle), ��������������
            % �������������� ������������ ��������� � ������� ��������� ����:
            %   function [ x2, y2 ] = F( x1, y1 ) 
            % ��� 
            %   function [ x2, y2 ] = F( x1, y1, p1,...,pn )
            % ��������������, ��� x1, y1 - ��������� ���������� ��������� ���������
            % (������������) ����� ���������, x2, y2 - ��������� ���������� �� ������ ���
            % ����������� F ( ��� �������-������������� ����� ���� ����� ������, �� ����, 
            % ��� � �������, ��� F, �� ������� �������� f = @F - ��� ������ �� ������� F )
            % - p1,...,pn - ����� �������������� ���������� ��� ������� f 
            % (����� �������������� ���������� � �� ���� ����� ���� ������)
            %
            %����:
            % - ���������� ���� �����, ������������ �� ���������� ������
            % obj, ������������� ��� ������ ������� f

            obj.pero.transform( f, varargin{:} );
        end
        
        
        
        function set( obj, varargin )
            %set - ������������� �������� ������� ������� ������ Turtle
            %
            %���������:
            %       obj.set( 'angle'     , angle )   % - ��������� ���������� �������� ���� �������� ��������           
            %       obj.set( 'step'      , step )    % - ��������� �������� ���� ��������            
            %       obj.set( 'lineColor' , color )   % - ��������� ����� �����   
            %       obj.set( 'patchColor', color )   % - ��������� ����� �������
            %       obj.set( 'lineStyle' , style )   % - ��������� ����� �����                
            %       obj.set( 'lineWidth' , width )   % - ��������� ������� ����� 
            %       obj.set( 'marker'    , marker )  % - ��������� ���� �������
            %       obj.set( 'markerSize , size )    % - ��������� ������� �������   
            %       obj.set( 'bufsize'   , bufSize ) % - ��������� ������� ������                        
            %       obj.set( 'delay'     , delay )   % - ��������� �������� ������������ ��������
            %
            %   ����� ����� ����� ������� �� ����� ����� ����� ������������� ������������:    
            %    
            %       obj.set( 'angle', angle, 'step', step, 'lineColor', color,..., 'delay', delay ) 
            %    
            %   (���� "��������-��������" ����� ��������� � ����� �������)        
            %
            %����:
            % - obj   = ��������� ������ ������ Turtle
            % - angle = ���������� �������� ���� �������� �������� � ���.
            % ( ���������� ���������� ���� pi/2 )
            % - step  = �������� ���� �������� ( ���������� ���������� ��� 1 ) 
            %   -----------------------------------------------------------
            % - color = ���� = 'b' | 'r' | 'g' | 'y' | 'k' | 'w' | 'm' | 3-������ double  
            %(���������� ���� ��������������� ������ 'b')
            % - style = ����� ����� = '-' | '--' | ':' | '-.' | 'none'   
            %(���������� ����� ����� ��������������� ������ '-')
            % - width  = ������� ����� = ������ double
            %(���������� ������� ����� ��������������� ������ 0.5)
            % - marker = ��� �������� = +' | 'o' | '*' | '.' | 'x' | 'square' | 'diamond' | ...
            %                        'v' | '^' | '>' | '<' | 'pentagram' | 'hexagram' | 'none'
            %( ���������� ����������� �������� 'none' )
            % - size = ������ �������� = ������ double ( ���������� ����������� �������� 6 )
            %   -----------------------------------------------------------
            % - bufSize = ������ ������ ( ����� ��������� � ���� �����; ���������� ����� ������ 1 )            
            % - delay = ������������ ������������ �������� � ���. = ������ double
            %( ���������� ����������� �������� 0 )
            %
            %����: 
            % - �������� �������� (�������) �������� �� ��������������� ��������             
            
            if numel( obj ) ~= 1
                error '����� set ����� ����������� ������ � ���������� �������'
            end
            
            if mod( numel( varargin ), 2 ) == 1
                error '����� ����������, ������������ ���� "��������-��������", ������ ���� ������'
            end
            
            for i = 1:2:length( varargin ) - 1
                
                switch upper( varargin{i} )
                    
                    case 'ANGLE'
                        
                        if isnumeric( varargin{i+1} ) && max( size( varargin{i+1} ) ) == 1
                            obj.anglE = varargin{i+1};
                        else
                            error '�������� �������� ''angle'' ������ ���� �������� ��������'
                        end
                        
                    case 'STEP'
                        
                        if isnumeric( varargin{i+1} ) && max( size( varargin{i+1} ) ) == 1
                            obj.ort = varargin{i+1};
                        else
                            error '�������� �������� ''step'' ������ ���� �������� ��������'
                        end
                        
                    otherwise
                        
                        obj.pero.set( varargin{i:i+1} )
                        
                end % switch                
            end % for            
        end % function set
        
        
       
        function disp( obj )
            %disp - ���������� ������ � ��������� ����
            
            if min( size( obj ) ) == 1
                disp '������ ������ Turtle ( < handle ):'
                disp( [' - �������� (����.) � ������ ������� ����������� �������� = ', num2str([angle( obj.ort)*180/pi, abs(obj.ort)])])
                disp( [' - ���������� �������� ���� �������� = ', num2str(obj.anglE*180/pi), ' ����.'])
            
                obj.pero.disp( 'prime' )
                
                disp ' - ������ ������: rot, forward, draw, set, disp'                
            else
                disp(['������ �������� ������ Turtle ������� ', num2str( size( obj, 1)), ' �� ', num2str( size( obj, 2) )])
            end          
        end % function disp 
        
    end % methods public 
    
end % classdef


