%����� Robot_ort, ������ ������ ����� ������ ��������
%������� ( handle ) �� ������, �������������� ����������� "���������������� ����� �� ��������� ����"
%
%��������� ��������� ( ������ ������ ):
% forward, right, left, is_bord, mark, is_mark, get_side, get_tmpr  
%
%����������� �����������, ��������� � �������� ������� ����������� ��������
%������������: 
%   ��� ������; ��������� ������; ��������� �������;
%   ���������, ���� �� ����������� ����� �� �����
%
%��. ����� ������� ����� Robot_ort_FRL
%
%-------------------------------------------------------------------------
%����: 04.09.2015
%-----------------------------------------------------------------------



classdef Robot_ort < handle
% Robot_ort - �����-�������� ������ Robot.Robot
       
    properties( Access = private ) 
        hField % ������ �� ������ ������ Robot.Robot (����� �� ��������� ����)
    end
               
    
    methods( Access = public )
       
        function obj = Robot_ort( mapfile )
            %Robot_ort - ����������� ������
            %
            %���������:
            %       r = Robot_ort()
            %       r = Robot_ort( mapfile ) 
            %
            %� 1-�� ������ ���������� ����������� ���������� ���� ��� 
            %������ �����, � ������ ������, ����������� ������ ���
            %����������� ���������� ����
            %
            %�� 2-� ������:
            % - mapfile - ��� �����, � ������� ��������� ���������� �� ����
            %
            %���������:
            % - r = ������ ( handle ) �� ��������� ������ ������ Rob_rel
            %
            %-------------------------------------------------------------
            % ��������� ��������� ������ ( ������ ������ ):
            %   forward, right, left, is_bord, mark, is_mark, get_side, get_tmpr  
            %
            %-------------------------------------------------------------
            %�������� ( ���������� ��� ��������������� ) ��������� ���������� 
            %�� ���� ����� � ������� ����:
            %  -���� �� ������ ������������� ������
            %  -���� �� ������� ������� ������
            %  -���� �� ���������� ����� ����� ���������� ���� �������������
            %  �����������
            %  -���� �� ����������� ������� �����������
            %  -���� �� ������ � ����������� ���� ��� ������������ �������
            %  ���������� ������ ����� �� �������� � ������ ������
            %  ( "������������" ������ ����� ����� "��������" ����� �������� )
            %����� ������ ����� ����� �������� ����� ����� ����� � ���������� 
            %����������
            %
            %-------------------------------------------------------------
            %��������� ��������� ������� �������������� ���������� �� ���� 
            %����� � ������� ���������� ������ CTRL+S 
            %( ��� ���� ���� � ������� ������ ���� �������! )
            %
            %������������ ��������� ����������� ���������� �� ���� ����� � ������� 
            %���������� ������ CTRL+R ( ��� ���� ���� � ������� ������ ���� �������! )
            %
            %����������� �������� ���������� ������ ����� � ������� ���������� ������
            %CRTL+T ( ��� ���� ���� � ������� ������ ���� �������! )
            %��������� ������� ���� ���������� ������ ������� �������� ���������� ��
            %������
            %����������������� �������� ���������� ����� ������������� ( ���������� ��������������
            %����������� ������ � ������������ ������, ��� ���������� �� �����
            %��������� CTRL+S )
            %
            %����������� ������ ����� �������� ���������� ������ ������ ������ � �������
            %���������� ������ CTRL+"����" ��� CTRL+"�����", ��������������            
            %( ��� ���� ���� � ������� ������ ���� �������! )
            
            if nargin == 0
                mapfile = [];
            end
            
            obj.hField = Robot_engine( mapfile, 'ort' );
                        
#            if ~isvalid( obj.hField )
#                % ���� �� �������                
#                delete( obj )
#            else
                set( obj.hField.hFig, 'userdata', obj ) %����� ����� ���� ������� ������ ��� �������� ���� ( ��. Robot.Robot.RobObjctDelete )
#            end
                                             
         end % function obj = Robot_ort 
        

        
        
        function forward( obj )
            %forward - ������� ����������� ������ ������ � �������� ������ 
            % 
            %���������:
            %           r.forward( )
            %
            %����:            
            % - r = ������ �� ������ ������ Rob_rel:
            %   ����� � �������� ������ ����, ����� �� ����� ������ 
            %   ����������� ���
            %
            %���������:
            % - ����� � �������� �� ����������� side ������ ( ����
            %   ������ �� ���� ������ ��� �����������, � ��������� ������ 
            %   ���������� "�������" ������ )

          
#            if ~isvalid( obj )
#                % ��� ��������, � ������ ������ ������������ ������� ���� � ��������������� �������
#                error '���� � ������� �����������'                
#            end
            
            if numel( obj ) ~= 1
                error '������� step ��������� ������ � ������ ���������� ������ ( � ������� ������ Rob_rel �� 1-�� �������� )'
            end
            
            if is_star_to_end( obj.hField.hFig ) == 1
                error '����� �� ����� � ������. ��������� ��������� ��������� ������� �������������� ���������� �� ���� ��������� ���������� CTRL+S (��� �������� ���� � �������) ��� ������������ �������� ���������� �������� CTRL+R'
            end
             
            side = obj.hField.get_side_();
            
            coderror = obj.hField.step( side );
            
            switch coderror
                case 3
                    error '����� ������� �� ����'
                case 4
                    error '�������� ��������� ������ ���� ''n'' | ''s'' | ''o'' | ''w'''                    
                case 5
                    error '��������� ������: ����� ������ �� ���������'                    
            end

        end % function forward
        
 
        
        function left( obj )
            %left - ������� ���������� ������ ����� 
            % 
            %���������:
            %           r.left( )
            %
            %����:            
            % - r = ������ �� ������ ������ Rob_rel:
            %   ����� � �������� ������ ����
            %
            %���������:
            % - ����� ��������� ����� �� 90 ��������
            
            if is_star_to_end( obj.hField.hFig ) == 1
                error '����� �� ����� � ������. ��������� ��������� ��������� ������� �������������� ���������� �� ���� ��������� ���������� CTRL+S (��� �������� ���� � �������) ��� ������������ �������� ���������� �������� CTRL+R'
            end
                                    
            coderror = obj.hField.rot( 'Left' );
            
            switch coderror
                case 3
                    error '����� ������� �� ����'
            end
            
        end
        
        
        
        function right( obj )
            %right - ������� ���������� ������ ������ 
            % 
            %���������:
            %           r.right( )
            %
            %����:            
            % - r = ������ �� ������ ������ Rob_rel:
            %   ����� � �������� ������ ����
            %
            %���������:
            % - ����� ��������� ������ �� 90 ��������
            
            if is_star_to_end( obj.hField.hFig ) == 1
                error '����� �� ����� � ������. ��������� ��������� ��������� ������� �������������� ���������� �� ���� ��������� ���������� CTRL+S (��� �������� ���� � �������) ��� ������������ �������� ���������� �������� CTRL+R'
            end
                                    
            coderror = obj.hField.rot( 'Right' );
            
            switch coderror
                case 3
                    error '����� ������� �� ����'
            end
            
        end
        
        
        
        function   ansv = is_bord( obj )
            %is_bord - ������� ��������� ������� ����������� ������� ������
            %
            %���������:
            %          ansv = r.is_bord( )
            %
            %����:
            % - r = ������ �� ������ ������ Rob_rel:
            %   ����� � �������� ������ ����
            %
            %���������:
            % - ansv = 1 ( true ), e��� � ����������� side ���� �����������  
            %        = 0 ( false ) - � ��������� ������ 
            
#            if ~isvalid( obj )
#                % ��� ��������, � ������ ������ ������� ���� � ��������������� �������
#                error '���� � ������� �� �������'                
#            end
                        
            if numel( obj ) ~= 1
                error '������� is_bord ��������� ������ � ������ ���������� ������ ( � ������� ������ RobAbs �� 1-�� �������� )'
            end
            
            if is_star_to_end( obj.hField.hFig ) == 1
                error '����� �� ����� � ������. ��������� ��������� ��������� ������� �������������� ���������� �� ���� ��������� ���������� CTRL+S (��� �������� ���� � �������) ��� ������������ �������� ���������� �������� CTRL+R'
            end
            
            side = obj.hField.get_side_();
            
            [ansv, coderror] = obj.hField.is_bord( side );

            switch coderror
                case 3
                    error '����� ������� �� ����'
                case 4
                    error '�������� ��������� ������ ���� ''n'' | ''s'' | ''o'' | ''w'''                    
            end
             
        end % function   ansv = is_bord

        
        
        
        function mark( obj )
            %mark - ������� ��������� ������ � ������ � �������
            %
            %���������:
            %           r.mark()
            %
            %����:
            % - r = ������ �� ������ ������ Rob_rel:
            %   ����� � �������� ������ ����
            %   
            %���������:
            % -  � ������ � ������� ����� ������ 
            %( ��������� ��������� ������ �� ��������, ����� ��� ������������ ������ ������ )
            
#            if ~isvalid( obj )
#                % ��� ��������, � ������ ������ ������� ���� � ��������������� �������
#                error '���� � ������� �� �������'                
#            end

            if numel( obj ) ~= 1
                error '������� mark ��������� ������ � ������ ���������� ������ ( � ������� ������ RobAbs �� 1-�� �������� )'
            end
            
            if is_star_to_end( obj.hField.hFig ) == 1
                error '����� �� ����� � ������. ��������� ��������� ��������� ������� �������������� ���������� �� ���� ��������� ���������� CTRL+S (��� �������� ���� � �������) ��� ������������ �������� ���������� �������� CTRL+R'
            end
            
            coderror = obj.hField.mark();
            
            switch coderror
                case 3
                    error '����� ������� �� ����'
            end            
        end % function mark
        
        
        
        function ansv = is_mark( obj )
            %is_mark - ������� ��������� ������� ������� ������ ����
            %
            %���������:
            %            ansv = r.is_mark()
            %
            %����:
            % - r = ������ �� ������ ������ Rob_rel:
            %   ����� � �������� ������
            %
            %���������:
            % - ansv = 1 ( true ), e��� � ������ � ������� ����� ������  
            %        = 0 ( false  ) - � ��������� ������ 
            
#            if ~isvalid( obj )
#                % ��� ��������, � ������ ������ ������� ���� � ��������������� �������
#                error '���� � ������� �� �������'                
#            end
            
            if numel( obj ) ~= 1
                error '������� is_mark ��������� ������ � ������ ���������� ������ ( � ������� ������ RobAbs �� 1-�� �������� )'
            end

            if is_star_to_end( obj.hField.hFig ) == 1
                error '����� �� ����� � ������. ��������� ��������� ��������� ������� �������������� ���������� �� ���� ��������� ���������� CTRL+S (��� �������� ���� � �������) ��� ������������ �������� ���������� �������� CTRL+R'
            end

            [ansv, coderror] = obj.hField.is_mark();
            switch coderror
                case 3
                    error '����� ������� �� ����'
            end   
            
        end % function ansv = is_mark
        
        
        
        function val = get_tmpr( obj )
            %get_tmpr - ������� �������� � �������� "�����������" ������� ������
            %
            %���������:
            %            val = r.get_tmpr()
            %
            %����:
            % - r = ������ �� ������ ������ Rob_rel:
            %   ����� � �������� ������
            %
            %���������:
            % - val = ����� ����� ( double ) = "�����������" ������ � �������
            %
            % ( ��� �������� ������ ������� ������ Rob_rel, "�������������"
            % ���� ����������� ��������, �� ��� �������� ����� ����������
            % ������� �� ����� - ��� ������� )
        
#            if ~isvalid( obj )
#                % ��� ��������, � ������ ������ ������� ���� � ��������������� �������
#                error '���� � ������� �� �������'
#            end    
            
            if numel( obj ) ~= 1
                error '������� get_tmpr ��������� ������ � ������ ���������� ������ ( � ������� ������ RobAbs �� 1-�� �������� )'
            end
            
            if is_star_to_end( obj.hField.hFig ) == 1
                error '����� �� ����� � ������. ��������� ��������� ��������� ������� �������������� ���������� �� ���� ��������� ���������� CTRL+S (��� �������� ���� � �������) ��� ������������ �������� ���������� �������� CTRL+R'
            end
            
            [val, coderror] = obj.hField.get_tmpr();

            switch coderror
                case 3
                    error '����� ������� �� ����'
            end
            
        end % function val = get_tmpr
        
        
        function side = get_side( obj )
            %get_side - ������� �������� ������� ����������� ������
            %
            %���������:
            %            side = r.get_side()
            %
            %����:
            % - r = ������ �� ������ ������ Rob_rel:
            %   ����� � �������� ������
            %
            %���������:
            % - side = 'n' (�����) | 's' (��) | 'o' (������) | 'w' (�����)
            %   - ������� ����������� ������
            % 

#            if ~isvalid( obj )
#                % ��� ��������, � ������ ������ ������� ���� � ��������������� �������
#                error '���� � ������� �� �������'
#            end
            
            if numel( obj ) ~= 1
                error '������� get_side ��������� ������ � ������ ���������� ������ ( � ������� ������ Rob_rel �� 1-�� �������� )'
            end
            
            if is_star_to_end( obj.hField.hFig ) == 1
                error '����� �� ����� � ������. ��������� ��������� ��������� ������� �������������� ���������� �� ���� ��������� ���������� CTRL+S (��� �������� ���� � �������) ��� ������������ �������� ���������� �������� CTRL+R'
            end
            
            [side, coderror] = obj.hField.get_side();
            
            switch coderror
                case 3
                    error '����� ������� �� ����'
            end
            
        end % function side = get_side
        
    end % methods public
        
end % classdef
