%����� Robot_engine
%
%� ������ �������� ����� ����� ������� ��������� ����������� ���� �
%��������� ����� � ������� �� ���
%��������� ������� ����� �� �����
%
%��������:
% hFig, hAxes, size, hRobot, hMark, outMarkPos tMap, hVerBord, hHorBord,
% isServiceable, fName
%
%������: ... + ����������� �������, �������������� �����������:
% - ��������� ������� ���������� �� ���� ����� � ������� ���������� ������
%CTRL+S ( ��� ���� ���� � ������� ������ ���� �������! )
%
%- ������������ ��������� ����������� ���������� �� ���� ����� � ������� 
%���������� ������ CTRL+R ( ��� ���� ���� � ������� ������ ���� �������! )
%
%- ����������� �������� ���������� ������ ����� � ������� ���������� ������
%CRTL+T ( ��� ���� ���� � ������� ������ ���� �������! )
%��������� ������� ���� ���������� ������ ������� �������� ���������� ��
%������.
%- ����������������� �������� ���������� ����� ������������� (���������� ��������������
%����������� ������ � ����������� ������, ��� ���������� ���������� ������
%�������������� �� ����� ��������� CTRL+S)
%
%- ����������� ������ ����� �������� ���������� ������ ������ ������ � �������
%���������� ������ CTRL+"����" ��� CTRL+"�����", ��������������
%( ��� ���� ���� � ������� ������ ���� �������! )
%
%-------------------------------------------------------------------------
%����: 11.09.2015
%-----------------------------------------------------------------------

classdef Robot_engine < handle
    
    properties( Access = public )
 
        robotType #
 
        hFig      % ���������� ������������ ����
        hAxes     % ���������� ������������ ����
        size      % ����� ����� � �������� ������ ����
        hFramework # дескриптор внешней рамки поля
                   # + в инструменты добавить соответствующую КНОПКУ 

        hRobot    % c����� �� ������ ������ Robot ��� RobOrt (!!! � ���������, �� ����� �������� delay )
        fhBody  # function_handle
        
        hMark     % ������� cell, ���������� [] ��� c����� �� ������� ������ Marker
        %( ���������� ������� � ������ �������� ��� ������ ��������
        %���������������� �������� ������� ��� �������� ��� ���������� ������� ������ Marker )
        
        outMarkPos % [] | ������� double, � ������� ���������� ������� ������, ��������������� ������� � ���������, ���������������� �� ��������� ������� ����� ���� (��������, ���� ������ �������� outside == 'nomark')
         
        tMap  % ������� ���������� ������ ����
        
        hVerBord  % ������� cell, ���������� [] ��� ������ �� ������������ ����������� ( ������� ������ Border )
        hHorBord  % ������� cell, ���������� [] ��� ������ �� �������������� ����������� ( ������� ������ Border )        
        % � ������ ������� �������������� ��� ����������� ������ (�������������� �����������)
        % ��� ���������� ����� ( ������������ ����������� ) ��� �����������
        % ����������� ( ���������� ���������� �������� ��� ������ ��������
        % �������� ������� ��� �������� ��� ���������� ������� ������ Bord )
        
        isServiceable % = true % = true | false - ����, ������������ ����������� ��������� ������� ( ����� ����� ���� "������ ����� ������" )      
                
        fName % ��� mat-�����, � ������� ����� ����������� ������ (������ Rob_???) ��� ������ r 
        %       ��� ���������� ���������������� ������ � ���������� ������� ���������� CTRL + S

        hLoadTool    #
        hSaveTool    #
        hRestoreTool #
        hAddDelayTool   #
        hShowValuesTool  #
        
###        hRobotTypeTool  #
        
        hHelpTool   #
        
        hFrameworkTool   #
        hHeightPlusTool  #
        hHeightMinusTool #
        hWidthPlusTool   #
        hWidthMinusTool  #
        
        borderWidth #
        borderColor #
        
        delay     #
        delay_def #
        
    end % properties( Access = public )   
    
    
    
    properties( Access = public )        
        
        diametr % = 40 % = Robot.Options.diametr 
            % - ������ ������ � �������� ��� �������� figure, ��������, = 40
            % ( !!! ��� ���� ������ ������ ��� �������� axes ��� �������� 
            % ������ ������ 1, �� ��� ����� �� ������� �� ��������� diametr, 
            % ������� � ���������� ����������� ������ ������ �� ������ ),
            
        hTexts
    end % properties private


    
    methods( Access = public )

        function  obj = Robot_engine( mapfile, robot_type )
            %Robot - ����������� ������
            %������� (��� �� �������, ���� � ������� ��������� �����) ���� � �������
            %��� ������ ������������ ��������� ��������� body 
            %
            %���������:
            %           obj = Robot_engine( [],... )
            %           obj = Robot_engine( mapfile,... )   
            %           obj = Robot_engine( ..., 'no_ort' )
            %           obj = Robot_engine( ..., 'ort' )   
            
            %
            %����:
####            % - body = @Body4 (������������� Rob_abs) | @Body1 (������������� Rob_rel)
            % - robot_type = 'Robot' | 'Robot_ort' | 'Robot_rot'
            %
            % - mapfile - [] | ��� ����� ( mat-�����, ���� ���������� ����� �����
            % ���� ������ ), � ������� ��������� ����� ������������ ���������� �� ����
            %
            %���������:
            % - �������� ( mapfile = [] ) ������ � �������������
            % 
            % - obj = ������ ( handle ) �� ��������� ������ ������ Robot_engine
            % ��������, ��� ������ obj ������ ( deleted obj ), ��� ��������, ��� ���� ������ �������, 
            % �� �����-���� �������
            %
            # - ссылка obj записана в userdata текущих координатных осей

#######################################
%            try 
%                load('delay.mat','delay')
%            catch
%                delay = 0.1;
%                save('delay.mat','delay')
%            end 
#            obj.delay = delay;
#######################################

            obj.delay_def = 0.2;
            obj.delay = obj.delay_def; 
            #Значение delay может быть изменено с помощью соответствующего инструмента
            
            
            
            obj.isServiceable = true;
            obj.diametr = 40;
            obj.borderWidth = 4;
            obj.borderColor = 'b';
            obj.robotType = robot_type;
            
            switch robot_type
            case 'Robot'
                body = @Body4;
            case {'Robot_ort', 'Robot_rot'}
                body = @Body1;
            otherwise 
                error 'Не предусмотренное значение параметра'
            end
            
            obj.fhBody = body;             
            
            if isempty( mapfile )  %nargin == 1
                % ��������� ������� ����
                obj.fName = 'untitled.map';
                obj = field_create( obj, [12, 12] ); 
#????           # Здесь выходной параметр нужен потому, что конструктор класса 
                # Robot_engine еще не завершен
                # и поэтому obj пока еще не является ссылкой
            else % ������� �������� mapfile - �� ������ 
                [~, name, ext] = fileparts( mapfile );
                obj.fName = [name, ext];
            
                obj = field_create( obj );                    
            end % if isempty( mapfile )
            
        end % function Robot_engine
    

        
        function coderror = step( obj, side )
            %step - ������� ����������� ������ � �������� ������ � �������� �����������
            % 
            %���������:
            %          coderror =  r.step( side )
            %
            %����:            
            % - side = 'n' | 's' | 'o' | 'w' - �������� �����������
            % - r = ������ �� ������ ������ Rob_abs:
            %   ����� � ��������� ������ ����, �� ������� side �� ������ 
            %   ����������� ���
            %
            %���������:
            % - ����� � �������� �� ����������� side ������ ( ����
            %   ������ �� ���� ������ ��� �����������, � ��������� ������ 
            %   ���������� "�������" ������ )
            % - coderror = 0 | 1 | 2 | 3 | 4 | 5
            %       0 - ������� ��������� �������
            %       1 - ������� ��������� ������ � ���������� �������
            %       2 - ��������� �������������� ���������� �� ��������
            %       3 - ����� � ��������� "������� �� �����"
            %       4 - �������� �������� �������� ���������, �������������
            %       �����������
            %       5 - ����� ������� �� �����
            
            coderror = 0;
            
            if numel( obj ) ~= 1
                coderror = 1;
                return
            end
            
            if is_star_to_end( obj.hFig ) == 1
                coderror = 2;
                return
            end
            
            if obj.isServiceable == 0
                coderror = 3;
                return
            end
            
 #####           pause( obj.hRobot.delay )
                        
            switch side
                
                case { 'n', 'N' }
                    vect = [0, 1]; % ��� ��������� ��������, ���� ������ ����� ��������������
                case { 's', 'S' }
                    vect = [0, -1];
                    
                case { 'o', 'O' }
                    vect = [1, 0];
                    
                case { 'w', 'W' }
                    vect = [-1, 0];
                    
                otherwise
                    coderror = 4;
                    return
            end
                        
            if ~obj.is_bord_without_effects( side )
                obj.hRobot.shift( vect, 'vector', obj.delay )
            else
                obj.hRobot.shift( vect/4, 'vector', obj.delay )
                obj.isServiceable = false;
                
                coderror = 5;
                return
            end
            
        end % function step
        
        
        
        function coderror = rot( obj, side )
            %rot - ������������ ������ � �������� ����������� � ���������
            %
            %���������:
            %           coderror = rot( obj, side )
            %����:
            % - r = ������ �� ������ ������ Rob_abs:
            %   ����� � ��������� ������ ����, �� ������� side �� ������ 
            %   ����������� ���            
            % - side = 'Right' | 'Left' | 'Back' (������� �������� ��
            % �����)
            %���������:
            % - coderror = 0 | 1 | 2 | 3 | 4
            %       0 - ������� ��������� �������
            %       1 - ������� ��������� ������ � ���������� �������
            %       2 - ��������� �������������� ���������� �� ��������
            %       3 - ����� � ��������� "������� �� �����"
            
            coderror = 0;
            
            if numel( obj ) ~= 1
                coderror = 1;
                return
            end
            
            if is_star_to_end( obj.hFig ) == 1
                coderror = 2;
                return
            end
            
            if obj.isServiceable == 0
                coderror = 3;
                return
            end
            
            switch upper( side )
                case {'RIGHT','R', 'LEFT','L', 'BACK','B'}
                otherwise
                    coderror = 4;
                    return
            end
                   
#            pause( obj.hRobot.delay )
            obj.hRobot.rot( side, obj.delay )
                        
        end

        
        
        function   [ansv, coderror] = is_bord( obj, side )
            %is_bord - ������� ��������� ������� ����������� � �������� �����������
            %
            %���������:
            %          ansv = r.is_bord( side )
            %
            %����:
            % - side = 'n' | 's' | 'o' | 'w' - �������� �����������
            % - r = ������ �� ������ ������ Robot:
            %   ����� � �������� ������ ����
            %
            %���������:
            % - ansv = 1 ( true ), e��� � ����������� side ���� �����������  
            %        = 0 ( false ) - � ��������� ������ 
            %        = [] - � ������ ���������� ����������
            % - coderror = 0 | 1 | 2 | 3 | 4
            %       0 - ������� ��������� �������
            %       1 - ������� ��������� ������ � ���������� �������
            %       2 - ��������� �������������� ���������� �� ��������
            %       3 - ����� � ��������� "������� �� �����"
            %       4 - �������� �������� �������� ���������, �������������
            %       �����������
            
            coderror = 0;
            ansv = [];
            
            if numel( obj ) ~= 1
                coderror = 1;
                return
            end
            
            if is_star_to_end( obj.hFig ) == 1
                coderror = 2;
                return
            end
            
            if obj.isServiceable == 0
                coderror = 3;
                return
            end
            
            if ~ismember( upper( side ), 'NSOW')
                coderror = 4;
                return
            end 
            
            if strcmp( class( obj.hRobot ), 'Body1' ) == 1
                obj.hRobot.is_bord( obj.delay )   
            elseif strcmp( class( obj.hRobot ), 'Body4' ) == 1
                
                obj.hRobot.is_bord( side, obj.delay )

            else
               error '�� ��������������� ��� ������' 
            end
                        
            ansv = obj.is_bord_without_effects( side );
            
        end % function   ansv = is_bord
        
        
        
        
        function coderror = mark( obj )
            %mark - ������� ��������� ������ � ������ � �������
            %
            %���������:
            %           coderror = r.mark()
            %
            %����:
            % - r = ������ �� ������ ������ Robot:
            %   ����� � �������� ������ ����
            %   
            %���������:
            % -  � ������ � ������� ����� ������ 
            %( ��������� ��������� ������ �� ��������, ����� ��� ������������ ������ ������ )
            %
            % - coderror = 0 | 1 | 2 | 3
            %       0 - ������� ��������� �������
            %       1 - ������� ��������� ������ � ���������� �������
            %       2 - ��������� �������������� ���������� �� ��������
            %       3 - ����� � ��������� "������� �� �����"
            
            coderror = 0;
            
            if numel( obj ) ~= 1
                coderror = 1;
                return
            end
            
            if is_star_to_end( obj.hFig ) == 1
                coderror = 2;
                return
            end
            
            if obj.isServiceable == 0
                coderror = 3;
                return
            end
            
            pos = obj.hRobot.position;

            if  obj.is_out() == 1
                % ����� - �� ������ ������� ����� ����
                 pause( obj.delay )
               
#                if strcmp( obj.outside, 'nomark' ) == 1
#                    isnew = true;
                    for i = 1:builtin( 'size', obj.outMarkPos, 1 )
                        if isequal( pos, obj.outMarkPos(i,:) ) == 1
%                            isnew = false;
                            break
                        end
                    end
#                    if isnew == 1
                        obj.outMarkPos = [obj.outMarkPos; pos];
#                    end
#                end
                
                
            else  
                % ����� - � �������� ������� ����� ����
                
                if isempty( obj.hMark{pos(1),pos(2)} ) #...
                        #|| ~obj.hMark{pos(1),pos(2)}.isvalid()

                    coord = [pos(2), pos(1)] - 1;
                    obj.hMark{pos(1),pos(2)} = Marker( coord(1), coord(2), obj.hAxes );
                end
                
                obj.hRobot.mark( obj.delay ) % - ������������� ���� ����������
            end
                     
        end % function mark
        
        
        
        
        function [ansv, coderror] = is_mark( obj )
            %is_mark - ������� ��������� ������� ������� ������ ����
            %
            %���������:
            %            [ansv, coderror] = r.is_mark()
            %
            %����:
            % - r = ������ �� ������ ������ Robot:
            %   ����� � �������� ������
            %
            %���������:
            % - ansv = 1 ( true ), e��� � ������ � ������� ����� ������  
            %        = 0 ( false  ) - � ��������� ������ 
            %        = [] - � ������ ���������� ����������
            % - coderror = 0 | 1 | 2 | 3 | 4
            %       0 - ������� ��������� �������
            %       1 - ������� ��������� ������ � ���������� �������
            %       2 - ��������� �������������� ���������� �� ��������
            %       3 - ����� � ��������� "������� �� �����"
            
            coderror = 0;
            ansv = [];
            
            if numel( obj ) ~= 1
                coderror = 1;
                return
            end
            
            if is_star_to_end( obj.hFig ) == 1
                coderror = 2;
                return
            end
            
            if obj.isServiceable == 0
                coderror = 3;
                return
            end

            pos = obj.hRobot.position;
            if obj.is_out() == 1
                % ����� - �� ������ ������� ����� ����
                
#                if strcmp( obj.outside, 'nomark' ) == 1 
                    ansv = 0;
                    for i = 1:builtin( 'size', obj.outMarkPos, 1 )
                        if isequal( pos, obj.outMarkPos(i,:) ) == 1
                            ansv = 1;
                            break
                        end
                    end
#                elseif strcmp( obj.outside, 'ismark' ) == 1
#                    ansv = true;
#                end
                pause( obj.delay )
                
            else  
                % ����� - � �������� ������� ����� ����
                
                if ~isempty( obj.hMark{pos(1),pos(2)} ) # ...
                        # && obj.hMark{pos(1),pos(2)}.isvalid()

                    ansv = true;
                else
                    ansv = false;
                end

                obj.hRobot.is_mark( obj.delay ) % ������������ ��������             
            end
        end % function ansv = is_mark

        
        
        function [val, coderror] = get_tmpr( obj )
            %get_tmpr - ������� �������� � �������� "�����������" ������� ������
            %
            %���������:
            %            [val, coderror] = r.get_tmpr()
            %
            %����:
            % - r = ������ �� ������ ������ Robot:
            %   ����� � �������� ������
            %
            %���������:
            % - val = ����� ����� ( double ) = "�����������" ������ � �������
            %
            % ( ��� �������� ������ ������� ������ Robot, "�������������"
            % ���� ����������� ��������, �� ��� �������� ����� ����������
            % ������� �� ����� - ��� ������� )
            % - coderror = 0 | 1 | 2 | 3 | 4
            %       0 - ������� ��������� �������
            %       1 - ������� ��������� ������ � ���������� �������
            %       2 - ��������� �������������� ���������� �� ��������
            %       3 - ����� � ��������� "������� �� �����"
                        
            coderror = 0;
            val = [];
            
            if numel( obj ) ~= 1
                coderror = 1;
                return
            end
            
            if is_star_to_end( obj.hFig ) == 1
                coderror = 2;
                return
            end
            
            if obj.isServiceable == 0
                coderror = 3;
                return
            end
            
            position = obj.hRobot.position;
            
            if position(1) <= 0
                position(1) = 1;
            elseif position(1) > obj.size(1)
                position(1) = obj.size(1);
            end
                        
            if position(2) <= 0
                position(2) = 1;
            elseif position(2) > obj.size(2)
                position(2) = obj.size(2);
            end            
           
            
            val = obj.tMap( position(1), position(2) ); 
            obj.hRobot.meas( obj.delay )% - ������������� ���� "���������"
            
        end % function val = get_tmpr
        
        
        
        
        function [side, coderror] = get_side( obj )
            %get_side - ������� �������� ������� ����������� ������
            %
            %���������:
            %            [side, coderror] = r.get_side()
            %
            %����:
            % - r = ������ �� ������ ������ Robot:
            %   ����� � �������� ������
            %
            %���������:
            % - side = 'n' (�����) | 's' (��) | 'o' (������) | 'w' (�����)
            %   - ������� ����������� ������
            % 
            % - coderror = 0 | 1 | 2 | 3 | 4
            %       0 - ������� ��������� �������
            %       1 - ������� ��������� ������ � ���������� �������
            %       2 - ��������� �������������� ���������� �� ��������
            %       3 - ����� � ��������� "������� �� �����"
            
            side = [];
            coderror = 0;
            
            if numel( obj ) ~= 1
                coderror = 1;
                return
            end
            
            if is_star_to_end( obj.hFig ) == 1
                coderror = 2;
                return
            end
            
            if obj.isServiceable == 0
                coderror = 3;
                return
            end
            

            obj.hRobot.get_side( obj.delay )% - ������������� ���� "���������"

            side = obj.hRobot.side; 
            switch side
                case 0
                    side = 'n';
                case 1
                    side = 'o';
                case 2
                    side = 's';
                case 3
                    side = 'w';
                otherwise
                    error '�� ������ �������� ����������'
            end
            
        end % function side = get_side
        

        
        
        function side = get_side_( obj )
            %get_side_ - ���������� ������� ����������� ������ ���
            %������������
            %
            %���������:
            %            side = r.get_side_()
            %
            %����:
            % - r = ������ �� ������ ������ Robot:
            %   ����� � �������� ������
            %
            %���������:
            % - side = 'n' (�����) | 'o' (������) | 's' (��) | 'w' (�����)
            %   - ������� ����������� ������

            side = decod_side( obj.hRobot.side ); 
                        
        end % function side = get_side_

            
        
       
        
        
    end % methods   
    
    
    methods( Access = private )
        
        
        function ansv = is_out( obj )
           % ansv = 1 (true), ���� ����� ��������� �� ��������� ����
           %      = 0 (false) - � ��������� ������
           
            pos = obj.hRobot.position;
            if pos(1) < 1 || pos(1) > obj.size(1)...
                    || pos(2) < 1 || pos(2) > obj.size(2)
                ansv = true;
            else
                ansv = false;
            end
            
        end
    
    
    
        
        function   ansv = is_bord_without_effects( obj, side )
            % ��������� ������� ������� � �������� ����������� ���
            % ������������ ( ������� �����, �������� )
            
            position = obj.hRobot.position;
            i = position(1);
            j = position(2);

%             if side == 0
%                 side = 'n';
%             elseif side == 1
%                 side = 'o';
%             elseif side == 2
%                 side = 's';
%             elseif side == 3
%                 side = 'w';
%             else
%                 error '�������� ��������� ������ ���� ����� 0 | 1 | 2 | 3'
%             end
            
            switch side
                
                case {'n', 'N'}
                    
                    if i >= obj.size(1) % ������� ��������������� ��� ���������
                        if ~isempty(obj.hFramework) #strcmpi( obj.outside, 'none' )
                            ansv = true;
                        else % ������� ������������
                            ansv = false;
                        end
                        
                        return
                    elseif i < 1
                        ansv = false;
                        return
                    end
                    
                    if j > obj.size(2) % ����� ��� �� ��������� ����
                        j = obj.size(2);
                    elseif j < 1 %  ����� ��� �� ��������� ����
                        j = 1;
                    end
                    
                    if ~isempty( obj.hHorBord{i,j})#...
                           # && obj.hHorBord{i,j}.isvalid()
                           # при этом необходимо изменить функцию delete_border
                           # так, чтобы при  удалении obj.hHorBord{i,j} = []
                        ansv = true;
                    else
                        ansv = false;
                    end
                     
                case { 's', 'S' }
                    
                    if i <= 1
                       if ~isempty(obj.hFramework)#strcmpi( obj.outside, 'none' )
                           ansv = true;
                       else
                           ansv = false;
                       end
                        
                       return
                    elseif i > obj.size(1)
                        ansv = false;
                        return
                    end

                    if j > obj.size(2) %  ����� ��� �� ��������� ����
                        j = obj.size(2);
                    elseif j < 1 %  ����� ��� �� ��������� ����
                        j = 1;
                    end                    
                    
                    if ~isempty( obj.hHorBord{i-1,j}) #...
                            #&& obj.hHorBord{i-1,j}.isvalid()
                        
                        ansv = true;
                    else
                        ansv = false;
                    end
                   
                case { 'o', 'O' }
                    
                    if j >= obj.size(2)
                        if ~isempty(obj.hFramework) #strcmpi( obj.outside, 'none' )
                            ansv = true;
                        else
                            ansv = false;
                        end
                        
                        return
                    elseif j < 1
                        ansv = false;
                        return
                    end
 
                    if i > obj.size(1) %  ����� ��� �� ��������� ����
                        i = obj.size(1);
                    elseif i < 1 %  ����� ��� �� ��������� ����
                        i = 1;
                    end                    
                                        
                    if ~isempty( obj.hVerBord{i,j})#...
                            #&& obj.hVerBord{i,j}.isvalid()
                        
                        ansv = true;
                    else
                        ansv = false;
                    end
                    
                case { 'w', 'W' }
                    
                    if j <= 1
                        if ~isempty(obj.hFramework) #strcmpi( obj.outside, 'none' )
                            ansv = true;
                        else
                            ansv = false;
                        end
                        
                        return
                    elseif j > obj.size(2)
                        ansv = false;
                        return
                    end
                    
                    if i > obj.size(1) %  ����� ��� �� ��������� ����
                        i = obj.size(1);
                    elseif i < 1 %  ����� ��� �� ��������� ����
                        i = 1;
                    end                    
                    
                    if ~isempty( obj.hVerBord{i,j-1})#...
                            #&& obj.hVerBord{i,j-1}.isvalid()
                        
                        ansv = true;
                    else
                        ansv = false;
                    end
                    
            end % switch side
             
        end % function   ansv = is_bord_without_effects

        
    end % methods( Access = public )
    
    
    
    methods( Static, Access = public )
                
        
        function [i,j] = get_index_cage ()
        % возвращает индексы клетки, по которой кликнули мышью
        
            point = get( gca, 'currentpoint' );
            % point - ������� 2*3
            
            x = point(1,1);
            y = point(1,2);
            
            xf = floor (x);
            yf = floor (y);
            % xf, yf - ������ ������� ���� ������          
        
            i = yf + 1;
            j = xf + 1;
            % i, j - ������� ������ (i >= 1, j >= 1)         
        
        end
        
        
    end % methods( Static, Access = public )
    
end % classdef