function [xData, yData] = rot_data( xData, yData, phi, point ) 
%RotData - ��������� �������������� �������� ��������� ����� ������������ ������� ��� �������� ��
% �������� ���� ������ �������� �����
%
%���������:
%           [xData, yData] = RotData( xData, yData, phi, point )
%�������:
% - xData, yData - ������� double, ������������ ���������� �����
% ������������ �������
% ������������ �������
% - phi - ���� ��������
% - point = 2-������ double - �������� ���������� �����-����� ��������
%
%���������:
% - xData, yData - ������� double, ������������ ���������� ����� 
%   ������������ ������� ����� ��������

complexPoint = complex( point(1), point(2) );
complexData = complex( xData, yData ) - complexPoint;
complexData = complexData .* exp( 1i * phi ) + complexPoint;
xData = real( complexData );
yData = imag( complexData );
