%Body4 - ����� ��� ����������� ������������� ��������� �� ����������������
%������ ( < Body ( < handle ) )
%
%Protected - ������:
%   sond_data_init ( ���������� ������������ ������ )
%
%Public - ��������:
%   position, delay, moved ( ����������� �� Robot_Body )


classdef Body4 < Body
       
    methods( Access = public )
        
        function r = Body4( coordinates,  hFig )
            %����������� ���������������� ������ � ��� ������������ ������
            %
            %���������:
            %       r = Body4( coordinates, hFig )
            % - coordinates = [x, y]  - ��������� ���������� ������ ������� ���� ������
            % - hFig = ���������� ������������ ���� ������             
            %
            %       r = Body4( R, hFig )
            % - R = ������ ������ Robot_Body1 | ������ ������ Robot_Body4

            if isequal( class( coordinates ), 'Body1' )...
                    || isequal( class( coordinates ), 'Body4' )
                
                coordinates = fliplr( coordinates.position ) - 1;
            elseif ~ isreal( coordinates ) && numel( coordinates ) == 2
            
                error '������� �������� ������ ���� �������� ������ Robot_Body1 ��� Robot_Body4 ��� 2-�������� real doouble'
            end  
            
            r = r@Body( coordinates, hFig );  
            
                 
        end % function r = Body4
        
    end % methods( Access = public )
    
   
    
    methods( Access = protected )
        
        function sond_data_init(r)
            % ������� ������� ������ ��� ����� ������, ����� ��������
            % ��������� � ������ ��������� ( � ����� (0,0) )
            
            r.xData_0_L{1} = [-r.L/2  r.L/2 r.L/2 -r.L/2];                  
            r.yData_0_L{1} = [-r.L/2 -r.L/2 r.L/2  r.L/2] + r.R;
            
            for i = 2:4
                [ r.xData_0_L{i}, r.yData_0_L{i} ] = rot_data(r.xData_0_L{i-1}, r.yData_0_L{i-1}, pi/2, [0,0]);
            end
            
        end % function sond_data_init()
    end % methods( Access = private )
    
end % classdef
     
