%Body1 - ����� ��� ����������� ������������� ��������� ����������������
%������ ( < handle )
%
%������:
% shift1, rot, mark, is_mark, is_bord, meas

#Date: 04.09.2015

classdef Body1 < Body


    properties (Access = public)
        
        side % = 0 % = 0 | 1 | 2 | 3
        
    end
       
        
    
    methods( Access = public )
        
        function r = Body1( coordinates, hFig, side )
            %����������� ���������������� ������ � ��� ������������ ������
            %
            %���������:
            %       r = Body1( coordinates, hFig, side )
            % - coordinates = [x, y]  - ��������� ���������� ������ ������� ���� ������
            % - hFig = ���������� ������������ ���� ������            
            % - side = 0 | 1 | 2 | 3
            %
            %       r = Body1( R, hFig )
            % - R = ������ ������ Body1 | ������ ������ Body4
                     

            
            if nargin == 2 
                
                if strcmp( class( coordinates ), 'Body1' ) == 1
                    side = coordinates.side;
                elseif strcmp( class( coordinates ), 'Body4' ) == 1
                    side = 0; % - ���������� �� �����
                else
                    error '������� �������� ������ ���� �������� ������ Body1 ��� Body4'
                end
                
                coordinates = fliplr( coordinates.position ) - 1;
            end
            
            if ischar( side )
                error '�������� side ������ ����  0 | 1 | 2 | 3'
            end
            
            r = r@Body( coordinates, hFig );
            r.side = 0 ; % = 0 | 1 | 2 | 3
            
            if side == 1
                r.rot( 'RIGHT' )
            elseif side == 2
                r.rot( 'BACK' )
            elseif side == 3
                r.rot( 'LEFT' )
            end
            
            set( r.hL(3), 'ButtonDownFcn', @(h,d) r.rot_( 'BACK' , hFig  ) )
            set( r.hL(2), 'ButtonDownFcn', @(h,d) r.rot_( 'RIGHT', hFig ) )
            set( r.hL(4), 'ButtonDownFcn', @(h,d) r.rot_( 'LEFT' , hFig ) )
            
        end % function r = Body1
        
        
        
        function shift1( obj, coord, mode, delay )
            %��� �������� �������� ����������� ������ � ����������� ���������� �� ������
            %coord ��� � ����� coord � ��������� ���������� �� �����
            % - � ����������� �� �������� ��������� mode
            %
            % - coord = 2-������ double = ���������� ������� ����������� | ���������� ������ ������� 
            % - mode = 'vector' (��� ������������ �����������) | 'punct'(��� ������� �����������)
            %��������� ���� ��������� ���������� (��������� * � ����� �����
            %��������� ����)
                     
            #obj.shift@Body( coord, mode )
            obj.shift( coord, mode, delay )

            if strcmp( mode, 'punct' )
                obj.side = 0;
            end
                   
        end
        
        
        
        function rot( r, side, delay )
            %��������� �������  �� 90 ��� 180 �������� ����� ��� ������ - �
            %����������� �� �������� side ������ ������ ������
            % - side = 'Left' | 'Right' | 'Back' ( �������� �������� �� ����� )
            %���� ����� ����� �������������� ����������, �� ��������� ������
            %��� ���������� ���������� �������������� � ������� * � �����
            %����� ����
                
%             Robot_Control_SaveDialog( r.hFig ) 

            pause( delay )
            
            switch upper( side )
                case {'LEFT','L'}
                    phi = pi/2;
                    r.side = mod( r.side - 1, 4 );
                case {'RIGHT','R'}
                    phi = -pi/2;
                    r.side = mod( r.side + 1, 4 );
                case {'BACK','B'}
                    phi = pi;
                    r.side = mod( r.side + 2, 4 );
                    
                otherwise
                    error '�� ��������������� �������� ���������'                    
            end % switch upper( side )
                  
            point = fliplr( r.position ) - 0.5; 
            % ���������� ������ ������
            
            for i = 1:4
                xData = get( r.hL(i), 'xdata' );
                yData = get( r.hL(i), 'ydata' );
                [xData, yData] = rot_data( xData, yData, phi, point );
                set( r.hL(i), 'xdata', xData )
                set( r.hL(i), 'ydata', yData )
            end % for
            
        end % function Rot( r, side )
        
        
        %----------------------------------------
        function is_bord( r, delay )
        %������������� ���� ��������
        % � ������������� ��������� ���������
           
            clr = get( r.hL(1), 'facecolor' );
            set( r.hL(1), 'facecolor', 'g' );            
            pause( delay )
            set( r.hL(1), 'facecolor', clr );
            
        end % function is_bord
        
        
        
        function get_side( r, delay )
        %������������� ���� ����������� �����������
        % � ������������� ��������� ���������
           
            clr = get( r.hL(1), 'facecolor' );
            set( [r.hL(1),r.hL(3)], 'facecolor', 'r' );            
            pause( delay )
            set( [r.hL(1),r.hL(3)], 'facecolor', clr );
            
        end % function is_bord

    end % methods public
        
    
    
    
    methods( Access = protected )
        
        function sond_data_init( r )
            % ������� ������� ������ ��� ����� ������, ����� ��������
            % ��������� � ������ ��������� ( � ����� (0,0) )
            
            L = r.L;            
            
            t = -pi/4:-pi/2:-3*pi/4;
            segmXData  = L*sqrt(2)*cos(t);
            segmYData = L*sqrt(2)*sin(t);
            xData_0 = [0 segmXData];%[0  L/2  -L/2];
            yData_0 = [L/2 segmYData];%[ L/2 -L/2 -L/2];            
            r.xData_0_L{1} = xData_0;
            r.yData_0_L{1} = yData_0 + r.R;

            r.xData_0_L{3} = xData_0;
            r.yData_0_L{3} = yData_0 - 0.75*r.R;
            
            xData_0 = [-L/2 L/2  L/2 -L/2];
            yData_0 = [ L/2 -0.5*L -1.5*L -L/2];                        
            r.xData_0_L{2} = xData_0 + r.R;
            r.yData_0_L{2} = yData_0;

%             xData_0 = [-L/1.5 L/1.5  L/1.5 -L/1.5];
%             yData_0 = [ L/2 L/2 -L/2 -L/2];
%             r.xData_0_L{3} = xData_0;           
%             r.yData_0_L{3} = yData_0 - r.R;
           
            xData_0 = [-L/2 L/2  L/2 -L/2];
            yData_0 = [ -0.5*L L/2  -L/2 -1.5*L ];                        
            r.xData_0_L{4} = xData_0 - r.R;
            r.yData_0_L{4} = yData_0;
 
        end % function sond_data_init
        
    end % methods( Access = protected ) 
    
    
    
    methods( Access = private )
        
        function rot_( r, side, hFig )
            %��������� �������  �� 90 ��� 180 �������� ����� ��� ������ - �
            %����������� �� �������� side ������ ������ ������
            % - side = 'Left' | 'Right' | 'Back' ( �������� �������� �� ����� )
            %��������� ���� ��������� ���������� (��������� * � ����� �����
            %��������� ����)
            % - hFig - ���������� ������������ ���� ������ 

            r.rot( side)            
 
            %���������� ��������
            add_star_to_end( hFig ) 
           
        end % function rot_( r, side )

    end %  methods( Access = private )

end % classdef
     