%Date: 11.09.2015


classdef Robot < handle
       
    properties( Access = private )
        hRobot_engine % ссылка на объект Robot_engine
    end
    
    
    methods( Access = public )
       
        function obj = Robot( mapfile )
            %Robot - The constructor of a class
            %
            %SYNTAX:
            %       r = Robot()
            %       r = Robot( mapfile )            
            %WHERE:
            % - mapfile = Name of a mat-file with initial conditions
            % - r = The reference to the created object
            %
            %-------------------------------------------------------------            
            % All methods of a class Robot: 
            %     step, is_bord, mark, is_mark, get_tmpr  
            %
            
            
            if nargin == 0
                mapfile = [];
            else # проверка правильности параметра
                if ~ischar( mapfile ) || min(size(mapfile)) ~= 1
                    errordlg( 'The parametre should be vector of type char' );
                    return
                end
                
                [~, ~, ext] = fileparts( mapfile );
                if ~strcmpi( ext, '.map' )
                    errordlg('The file name should have expansion .map')
                    return
                end

                if exist( mapfile, 'file' ) ~= 2
                    % Файл не найден
                    errordlg( ['The file ', mapfile, ' is non found'] )
                    return
                end

            end
            
            obj.hRobot_engine = Robot_engine( mapfile, 'Robot' );


#В ОКТАВЕ 4.0 функция  isvalid еще не реализована           
#            if ~isvalid( obj.hRobot_engine )
#                delete( obj )
#            else


             set( obj.hRobot_engine.hFig, 'userdata', obj ) 
             # это используется, например, в функциях load_map, rob_objct_delete
             
#            end
                                             
        end % function obj = Robot 

        
 
  
        function step( obj, side )
            %step - Moves the Robot on one step to the set side
            % 
            %SYNTAX:
            %           r.step( side )
            %
            %WHERE:            
            % - side = 'n' | 's' | 'o' | 'w' 
            % - r = The handle to object of class Robot
            %
            
            #if ~isvalid( obj )
            #    error 'The reference to not existing object of class Robot'
            #end
             
            if nargin < 2
                error 'There is no the input parametre defining a side'
            end 
             
            if ishandle(obj.hRobot_engine.hFig) == 0
                error ('The window with the robot has been closed') 
                #Окно с роботом было закрыто') 
            end
            
            if numel( obj ) ~= 1
                error 'The reference to the Robot cannot be a array'
                %'Ссылка на Робота не может быть массивом'
            end
            
            if is_star_to_end( obj.hRobot_engine.hFig ) == 1
                error 'Conditions in the field are NOT SAVE after editing'
                #Обстановка на поле НЕ СОХРАНЕНА после редактирования
            end
            
            coderror = obj.hRobot_engine.step( side );
            
            switch coderror
                case 3
                    error 'The robot is not serviceable' 
                    %'Робот не исправен'
                case 4
                    error 'Not admissible value of parametre, admissible values: ''n'' | ''s'' | ''w'' | ''o'''
                    %'Не допустимое значение параметра, допустимые значения: ''n'' | ''s'' | ''o'' | ''w'''                    
                case 5
                    error 'Fatal error: the Robot has driven into a partition (border)'
                    %'Фатальная ошибка: Робот наехал на перегородку (бордюр)'                    
            end
                        
        end % function step
        
 
        
        
        function   ansv = is_bord( obj, side )
            %is_bord - Returns result of stock-taking of a border in the set side
            %
            %SYNTAX:
            %          ansv = r.is_bord( side )
            %
            %WHERE:
            % - side = 'n' | 's' | 'o' | 'w' 
            % - r = The handle to object of class Robot
            % - ansv = 1 ( true ) | 0 ( false ) 
            
            #if ~isvalid( obj )
            #    error 'The reference to not existing object of class Robot'
            #end
            

            if ishandle(obj.hRobot_engine.hFig) == 0
                error ('The window with the robot has been closed') 
                #Окно с роботом было закрыто') 
            end

            if numel( obj ) ~= 1
                error 'The reference to the Robot cannot be a array'
                %'Ссылка на Робота не может быть массивом'
            end
            
            if is_star_to_end( obj.hRobot_engine.hFig ) == 1
                error 'Conditions in the field are NOT SAVE after editing'
                #Обстановка на поле НЕ СОХРАНЕНА после редактирования
            end
           
            [ansv, coderror] = obj.hRobot_engine.is_bord( side );
            
            switch coderror
                case 3
                    error 'The robot is not serviceable' 
                    %'Робот не исправен'
                case 4
                    error 'Not admissible value of parametre, admissible values: ''n'' | ''s'' | ''w'' | ''o'''
                    %'Не допустимое значение параметра, допустимые значения: ''n'' | ''s'' | ''o'' | ''w'''                    
            end
             
        end % function   ansv = is_bord

        
        
        
        function mark( obj )
            %mark - Puts a marker in a current cage
            %
            %SYNTAX:
            %           r.mark()
            %
            %WHERE:
            % - r = The handle to object of class Robot            %   

            #if ~isvalid( obj )
            #    error 'The reference to not existing object of class Robot'
            #end

            if ishandle(obj.hRobot_engine.hFig) == 0
                error ('The window with the robot has been closed') 
                #Окно с роботом было закрыто') 
            end            
            
            if numel( obj ) ~= 1
                error 'The reference to the Robot cannot be a array'
                %'Ссылка на Робота не может быть массивом'
            end
            
            if is_star_to_end( obj.hRobot_engine.hFig ) == 1
                error 'Conditions in the field are NOT SAVE after editing'
                #Обстановка на поле НЕ СОХРАНЕНА после редактирования
            end
            
            coderror = obj.hRobot_engine.mark();
                       
            switch coderror
                case 3
                    error 'The robot is not serviceable' 
                    %'Робот не исправен'
            end            
        end % function mark
        
        
        
        function ansv = is_mark( obj )
            %is_mark - Returns result of stock-taking of a marker in a current cage
            %
            %SYNTAX:
            %            ansv = r.is_mark()
            %
            %WHERE:
            % - r = The handle to object of class Robot            %
            % - ansv = 1 ( true ) | 0 ( false  )

            #if ~isvalid( obj )
            #    error 'The reference to not existing object of class Robot'
            #end
            
            if ishandle(obj.hRobot_engine.hFig) == 0
                error ('The window with the robot has been closed') 
                #Окно с роботом было закрыто') 
            end            
            
            if numel( obj ) ~= 1
                error 'The reference to the Robot cannot be a array'
                %'Ссылка на Робота не может быть массивом'
            end

            if is_star_to_end( obj.hRobot_engine.hFig ) == 1
                error 'Conditions in the field are NOT SAVE after editing'
                #Обстановка на поле НЕ СХРАНЕНА после редактирования
            end

            [ansv, coderror] = obj.hRobot_engine.is_mark();

            
            switch coderror
                case 3
                    error 'The robot is not serviceable' 
                    %'Робот не исправен'
            end            
            
        end % function ansv = is_mark
        
        
        
        function val = get_tmpr( obj )
            %get_tmpr - Returns value of temperature in a current cage
            %
            %SYNTAX:
            %            val = r.get_tmpr()
            %
            %WHERE:
            % - r = The handle to object of class Robot
            % - val = temperature ( double )
            %

            %if ~isvalid( obj )
            #    error 'The reference to not existing object of class Robot'
            #end    
            
            if ishandle(obj.hRobot_engine.hFig) == 0
                error ('The window with the robot has been closed') 
                #Окно с роботом было закрыто') 
            end            
            
            if numel( obj ) ~= 1
                error 'The reference to the Robot cannot be a array'
                %'Ссылка на Робота не может быть массивом'
            end
            
            if is_star_to_end( obj.hRobot_engine.hFig ) == 1
                error 'Conditions in the field are NOT SAVE after editing'
                #Обстановка на поле НЕ СОХРАНЕНА после редактирования
            end
            
            [val, coderror] = obj.hRobot_engine.get_tmpr();
            
            switch coderror
                case 3
                    error 'The robot is not serviceable' 
                    %'Робот не исправен'
            end
            
        end % function val = get_tmpr
        
    end % methods public
       
end % classdef
