%����� Pero < handle
%
%������ ������:
%   Pero, punct, vector, draw, flip, transform, set, disp ( + ������ ����������� handle )
%
%-------------------------------------------------------------------------
%������: for Octave 4.0 (при попытке выполнить метода isvalid происсходит фатальная ошибка)
%����: 13.06.2015



classdef Pero < handle
    
    properties( Access = private )
        bufsize %= 200  % - ������ ������� ������ (1-� ������ �������� xdata, ydata)
        numpoint       % - ����� ����� �����, ���������� � �����
        xdata          % - �����
        ydata          % - �����
        
        daraw_enable_at_bufsize_equal_1 %= 'off' % - ��������� ������ ��� ��� bufsize = 1: 
        % ������������ ��� ����������� ����������� ������ ������ draw �� ������� punct, vector 
        % � ������, ����� bufsize = 1
        
        %�������� ������������ ������� ( ������������ ������� draw ) �� ���������:
        linecolor  %= 'b'
        patchcolor %= 'b'   % - ���� �������
        linewidth  %= 0.5
        linestyle  %= '-'
        marker     %= 'none'
        markersize %= 6 
        
        delay %= 0 % = �������������� ������������ ��������� �������� ��� ���������� ������ draw, ���
    end % properties private
    
    
    
    methods( Access = public )
        
        function obj = Pero( varargin )
            ##Pero - ����������� ������ ��� ����� ������
            %
            %���������:
            %           obj = Pero( x, y );
            %           obj = Pero( p1,...,pn ); 
            %����:
            % - x, y = ���������� ���������� ��������� ���� = ������� double
            %
            % ���  
            %   p1,...,pn (n>0) - ������ (< handle) �� ������� ������ Pero
            %
            %����:
            % - obj = ������ (< handle) �� (�����) ������ ������ Pero
            % - ���������� ����� ������� obj �������� ���������� ���������� 
            % ��������� ����
            % 
            % ���
            %   ���������� ����� ������� obj �������� ������������
            %   ��������� ��������� ����, ������������ � p1,...,p2
            %-------------------------------------------------------------------------
            %
            % ����� Pero ����� ���������� �����. 
            % ��� ������� ������ (����� ��������� � ���� �����) ������ 1,
            % ���������� ���� (� ������� ������� punct, vector) ������������� �������� 
            % � ���������� �������. ��� ���� �������� � ������� ��� ������ ������� 
            % draw � transform �� �������� ( ������� �� ���������� �������� � ������ ).
            % 
            % ��� ������� ������, ������� 1, ��� ������������ ���� (� ������� 
            % ������� punct, vector) ����� ����� ������� �������� �������������
            % � ���, �� �� ������������ � ������������ ����.
            % ��� ��������� ������� � ���� ������ ���������� ��������� ����� draw
            % ( ����� ����� � ������ ����������� ������ ��������� ����� ).
            %
            % �����, ���� ������ ������ ������ 1, �� ��� ������������ ������, ��� ������ 
            % ������������� ������������� ( �� �������� ���������������
            % ������� ������ ). 
            %
            % �������� ������ ������ ����� � ������� ������ set.
                        
 
 %------------------------------------------------                       
                        
            obj.bufsize = 200;  % - ������ ������� ������ (1-� ������ �������� xdata, ydata)
        
            obj.daraw_enable_at_bufsize_equal_1 = 'off'; % - ��������� ������ ��� ��� bufsize = 1: 
            % ������������ ��� ����������� ����������� ������ ������ draw �� ������� punct, vector 
            % � ������, ����� bufsize = 1
        
            %�������� ������������ ������� ( ������������ ������� draw ) �� ���������:
            obj.linecolor  = 'b';
            obj.patchcolor = 'b';   % - ���� �������
            obj.linewidth  = 0.5;
            obj.linestyle  = '-';
            obj.marker     = 'none';
            obj.markersize = 6; 
        
            obj.delay = 0; % = �������������� ������������ ��������� �������� ��� ���������� ������ draw, ���
%------------------------------------------------------------------            
            
            f = isnumeric(varargin{1});
            if f == 1 && numel(varargin) ~= 2
                error '����� ���������� ��������� ���� ������ ���� 2'
            end
            
            for i = 1:numel(varargin)
                if f == 1 && isnumeric(varargin{i}) == 0
                    error '1-�� �������� ����� �������� ���, � 2-�� - ���'
                elseif f == 0 && isa(varargin{i}, 'Pero') == 0
                    error '�� ��� ��������� ����� ��� Pero'
                end
            end
            
            
            if f == 1 % && numel(varargin) == 2 && ��� ����� ��� double
                x = varargin{1}; 
                y = varargin{2};    
                if numel( x ) ~= 1 || ~isnumeric( x )...
                        || numel( y ) ~= 1 || ~isnumeric( y )
                    
                    error '��� ������� ���������� ������� ���� ��������� ���������'
                end
                
                obj.xdata = zeros( obj.bufsize, 1 );
                obj.ydata = zeros( obj.bufsize, 1 );
                
                obj.xdata(1) = x;
                obj.ydata(1) = y;
                obj.numpoint = 1;
            else % f == 0 && ��� �������� varargin ����� ��� Pero
                
                n = 0; 
                m = 0;
                for i = 1:numel(varargin)
                    n = n + numel(varargin{i}.xdata); 
                    m = m + varargin{i}.numpoint;
                end
                
                obj.numpoint = m; % - ����� ����� �����, ���������� � �����
                
                if m <= 200
                    obj.bufsize = 200;  % - ������ ������� ������ (1-� ������ �������� xdata, ydata)
                else
                    obj.bufsize = 2 * m;
                end
                
                obj.xdata = zeros( obj.bufsize, 1 ); % - �����
                obj.ydata = zeros( obj.bufsize, 1 ); % - �����
                m = 0; 
                for i = 1:numel(varargin)
                    k = varargin{i}.numpoint;
                    obj.xdata(m+1:m+k) = varargin{i}.xdata(1:k);
                    obj.ydata(m+1:m+k) = varargin{i}.ydata(1:k);
                    m = m + k;
                end
                               
                obj.daraw_enable_at_bufsize_equal_1 = 'off'; % - ��������� ������ ��� ��� bufsize = 1: 
                % ������������ ��� ����������� ����������� ������ ������ draw �� ������� punct, vector 
                % � ������, ����� bufsize = 1

                %�������� ������������ ������� ( ������������ ������� draw ) �� ���������:
                obj.linecolor  = 'b';
                obj.patchcolor = 'b';   % - ���� �������
                obj.linewidth  = 0.5;
                obj.linestyle  = '-';
                obj.marker     = 'none';
                obj.markersize = 6; 

                obj.delay = 0; % = �������������� ������������ ��������� �������� ��� ���������� ������ draw, ���
               
            end
                
        end % function Pero
        
        
        function obj2 = flip( obj1 )
            %flip - �������������� ����� ������� ���������� ����������� ������ �������
            %
            %���������:
            %           obj2  = obj1.flip()
            
            if numel( obj1 ) ~= 1
                error '����� flip ����� ����������� ������ � ���������� �������'
            end
            
            obj2 = Pero(obj1);
            obj2.xdata = flipud(obj2.xdata);
            obj2.ydata = flipud(obj2.ydata);
        end
        
        
        function set( obj, varargin )
            %set - ������������� �������� ������� ������� ������ Pero
            %
            %���������:
            %    obj.set( 'lineColor' , color )   % - ��������� ����� �����   
            %    obj.set( 'patchColor', color )   % - ��������� ����� �������
            %    obj.set( 'lineStyle' , style )   % - ��������� ����� �����                
            %    obj.set( 'lineWidth' , width )   % - ��������� ������� ����� 
            %    obj.set( 'marker'    , marker )  % - ��������� ���� �������
            %    obj.set( 'markerSize , size )    % - ��������� ������� �������   
            %    obj.set( 'bufsize'   , bufSize ) % - ��������� ������� ������                        
            %    obj.set( 'delay'     , delay )   % - ��������� �������� ������������ ��������
            %
            %    ����� ����� ����� ������� �� ����� ����� ����� ������������� ������������:    
            %    
            %    obj.set( 'lineColor', color,..., 'delay', delay ) 
            %    
            %    (���� "��������-��������" ����� ��������� � ����� �������)        
            %
            %����:
            % - obj = ��������� ������ ������ Pero
            % - color = ���� = 'b' | 'r' | 'g' | 'y' | 'k' | 'w' | 'm' | 3-������ double  
            %(���������� ���� ��������������� ������ 'b')
            % - style = ����� ����� = '-' | '--' | ':' | '-.' | 'none'   
            %(���������� ����� ����� ��������������� ������ '-')
            % - width  = ������� ����� = ������ double
            %(���������� ������� ����� ��������������� ������ 0.5)
            % - marker = ��� �������� = +' | 'o' | '*' | '.' | 'x' | 'square' | 'diamond' | ...
            %                        'v' | '^' | '>' | '<' | 'pentagram' | 'hexagram' | 'none'
            %( ���������� ����������� �������� 'none' )
            % - size = ������ �������� = ������ double ( ���������� ����������� �������� 6 )
            % - bufSize = ������ ������                        
            % - delay = ������������ ������������ �������� � ���. = ������ double
            %( ���������� ����������� �������� 0 )
            %
            %����: 
            % - �������� �������� (�������) �������� �� ��������������� ��������             
            
            if numel( obj ) ~= 1
                error '����� set ����� ����������� ������ � ���������� �������'
            end

            if mod( numel( varargin ), 2 ) == 1
                error '����� ����������, ������������ ���� "��������-��������", ������ ���� ������'
            end
            
            for i = 1:2:length( varargin ) - 1
                if ~ischar( varargin{i} )
                    error('��� �������� ������ ���� ������� char')                    
                end

                switch upper( varargin{i} )
                    
                    case 'LINECOLOR'
                        if isnumeric( varargin{i+1} )
                            if min( size( varargin{i+1} ) ) ==  1 ...
                                && max( size( varargin{i+1} ) ) ==  3 ...
                                && all( varargin{i+1} >= 0 )...
                                && all( varargin{i+1} <= 1 )
                            
                                obj.linecolor = varargin{i+1};
                            else
                                error '������������ �������� �������� ''lineColor'''
                            end
                        else
                            switch varargin{i+1}
                                case {'r', 'g', 'b', 'k', 'm', 'y', 'w'}
                                    obj.linecolor = varargin{i+1};            
                                otherwise
                                    error '������������ �������� �������� ''lineColor'''
                            end         
                        end                      
                        
                    case 'PATCHCOLOR'
                        
                        if isnumeric( varargin{i+1} )
                            if min( size( varargin{i+1} ) ) ==  1 ...
                                && max( size( varargin{i+1} ) ) ==  3 ...
                                && all( varargin{i+1} >= 0 )...
                                && all( varargin{i+1} <= 1 )
                            
                                obj.patchcolor = varargin{i+1};
                            else
                                error '������������ �������� �������� ''patchColor'''
                            end
                        else
                            switch varargin{i+1}
                                case {'r', 'g', 'b', 'k', 'm', 'y', 'w'}
                                    obj.patchcolor = varargin{i+1};            
                                otherwise
                                    error '������������ �������� �������� ''patchColor'''
                            end         
                        end
                        
                   case 'LINESTYLE'
                       
                        switch varargin{i+1}
                            case {'-', '--', ':', '-.', 'none'}
                                obj.linestyle = varargin{i+1};            
                            otherwise
                                error '������������ �������� �������� ''lineStyle'''
                        end 
                        
                    case 'LINEWIDTH'
                        
                        if isnumeric( varargin{i+1} ) && max( size( varargin{i+1} ) ) == 1
                            obj.linewidth = varargin{i+1};
                        else
                            error '�������� �������� ''lineWidth'' ������ ���� �������� ��������'
                        end
                        
                    case 'MARKER'
                        
                         switch varargin{i+1}
                             case {'+', 'o', '*', '.', 'x', 'square', 'diamond', ...
                                    'v', '^', '>', '<', 'pentagram', 'hexagram', 'none'}

                                obj.marker = varargin{i+1};            
                             otherwise
                                 error '������������ �������� �������� ''marker'''
                         end
                              
                    case 'MARKERSIZE'
                        
                        if isnumeric( varargin{i+1} ) && max( size( varargin{i+1} ) ) == 1
                            obj.markersize = varargin{i+1};
                        else
                            error '�������� �������� ''markerSize'' ������ ���� �������� ��������'
                        end
                    
                    case 'DELAY'
                        
                        if isnumeric( varargin{i+1} ) && max( size( varargin{i+1} ) ) == 1
                            obj.delay = varargin{i+1};
                        else
                            error '�������� �������� ''delay'' ������ ���� �������� ��������'
                        end
                        
                    case 'BUFSIZE'
                        if obj.numpoint > 1
                            error '���������� �������� ����������� ������ ������, ����� ����� �������� ����� 1 �����'
                        end
                        
                        if isnumeric( varargin{i+1} ) && max( size( varargin{i+1} ) ) == 1 ...
                                &&  varargin{i+1} > 0 && fix( varargin{i+1} ) == varargin{i+1}
                                                       
                            obj.bufsize = varargin{i+1};
                            
                            xbuf = obj.xdata(1:obj.numpoint);
                            ybuf = obj.ydata(1:obj.numpoint);
                            
                            n = fix( obj.numpoint / obj.bufsize ) + 1;
                            
                            obj.xdata = zeros( obj.bufsize, n );
                            obj.ydata = zeros( obj.bufsize, n );
                            
                            obj.xdata(1:obj.numpoint) = xbuf;
                            obj.ydata(1:obj.numpoint) = ybuf;
                            
                        else
                            error '�������� �������� ''bufsize'' ������ ���� ������������� ����� ��������'
                        end
                        
                    otherwise
                        
                        error '����������������� ��� ��������'
                        
                end % switch                
            end % for       
        end % function set
                        
        
         
        function h = draw( obj, type, dx, dy )
            %draw - ������ ����� ��� ����������� ������� ( ��� ��
            %��������� ), ���������� ����� ������� ���������� �� ���������� ������
            %
            %���������:
            %           obj.draw()
            %           obj.draw( type )            
            %       h = obj.draw();   
            %       h = obj.draw( type );   
            %           obj.draw( type, dx, dy )            
            %       h = obj.draw( type, dx, dy );  
            %
            %����:            
            % - obj = ��������� ������ ������ Pero
            % - ���������� ������ ����������� ������ ������ 1            
            % - ���������� ����� �������� ������������������ ��������� ����� ����� 
            % - type = 'line' | 'patch' | []
            % ( �� ��������� type = 'line'  <=> type = [] )
            % - dx, dy - ���������� ������� �������� ���� 
            % ( �� ��������� dx = dy = 0 )
            %
            %����:
            % - � ������� ������������ ���� ��������� ����� 
            % � ����������������� ���������� 
            % ( ��������� ���������������� ������� ����� ���� ������������ � ������� ������ set )
            % 
            % - h = ���������� ����������� �����
            % - ���������� ����� �������� ������ ��������� ����� �� ��������
            % ������������������ �����, ��������� �� ������ dx,dy 
            % ( ����� �������� ���������� �������� ��������� ���� )
            % - ���������� ����� ��������� � �������������� ������������ ��������� 
            % ��������� �� ����������������� ��������
            % ( �� ��������� �������� �������� ����������� ������ 0, ��������
            % ��� ��������� ����� � ������� ������ Set )
            %
 
            if obj.bufsize == 1 && strcmpi( obj.daraw_enable_at_bufsize_equal_1, 'off' )
                error '����� draw �� ����� ����������� ��� ������������� ������� ������ ������ 1'
            end
            
            if numel( obj ) ~= 1
                error '����� draw ����� ����������� ������ � ���������� �������'
            end

            n = obj.numpoint;

            if obj.delay > 0
                h = [];
                for i = 1:n-1
                    h(i) = line(...
                        'xdata'     , obj.xdata(i:i+1),...
                        'ydata'     , obj.ydata(i:i+1),...
                        'color'     , obj.linecolor,...
                        'linewidth' , obj.linewidth,...
                        'linestyle' , obj.linestyle,...
                        'marker'    , obj.marker,...
                        'markersize', obj.markersize...                    
                        );
                    pause( obj.delay / (n-1) )
                end
                
                if obj.bufsize == 1 
                    
                    obj.xdata(1) = obj.xdata(n);
                    obj.ydata(1) = obj.ydata(n);
                    obj.numpoint = 1;    
                    
                    return
                end
                
                delete( h )
                clear h
            end
            
            if nargin > 1 && isequal(type, {})
                error '����������������� �������� ���������'
            end
            
            if nargin == 1 || strcmpi( type, 'line' ) || isempty( type )
                h = line(...
                    'xdata'     , obj.xdata(1:n),...
                    'ydata'     , obj.ydata(1:n),...
                    'color'     , obj.linecolor,...
                    'linewidth' , obj.linewidth,...
                    'linestyle' , obj.linestyle,...
                    'marker'    , obj.marker,...
                    'markersize', obj.markersize...                    
                    );
                
            elseif strcmpi( type, 'patch' )
                    
                h = patch(...
                    'xdata'          , obj.xdata(1:n),...
                    'ydata'          , obj.ydata(1:n),...
                    'edgecolor'      , obj.linecolor,...
                    'facecolor'      , obj.patchcolor,...
                    'markerEdgeColor', obj.linecolor,...
                    'markerFaceColor', obj.linecolor,...                        
                    'linewidth'      , obj.linewidth,...
                    'linestyle'      , obj.linestyle,...
                    'marker'         , obj.marker,...
                    'markersize'     , obj.markersize... 
                    ); 
                    
            else
                error '����������������� �������� ���������'
            end

            if nargin < 3
                dx = 0;
                dy = 0;
            elseif nargin == 3
		error ('�������� ������ ���������� ������� �������� ����')
	    elseif nargin == 4
		if isnumeric(dx) == 0 || isreal(dx) == 0 || numel(dx) ~= 1 ...
                || isnumeric(dy) == 0 || isreal(dy) == 0 || numel(dy) ~= 1
                    error ('�������� ������ ���������� ������� �������� ����')
                end
            elseif nargin > 4
		error ('������� ����� ������� ����������')
            end

                
            obj.xdata(1) = obj.xdata(n) + dx;
            obj.ydata(1) = obj.ydata(n) + dy;
            obj.numpoint = 1;    
            
            if nargout == 0
                clear h
            elseif nargout == 1
                h = reshape( h, size(obj) );
            else
                error '����� ����������� �������� ���������� �� ����� ���� ������ 1'
            end
                        
        end % function draw
        
        
        
        function vector( obj, dx, dy )
            %vector - "����������" ���� �� �������� ������ �� ��������� ����� ���������� ����� � ����� 
            %
            %���������:
            %           obj.vector( dx, dy )
            %����:
            % - obj = ��������� ������ ������ Pero
            % - ���������� ����� ������� obj �������� �� ������
            % ������������������ ����� (�� ������� ���� ���� �����)
            % - dx, dy = ���������� ������� �������� ���� � ��������� 
            % ����� ����� = ������� double            
            %
            %����:
            % - ��������� ����� ����� ������� ��������� � �����, ����
            % ������������� ������ ������ ������ 1, ��� ����� �����
            % ��������� ��������������� � �������, ���� ������ ������ ����� 1 
            
            if numel( obj ) ~= 1
                error '����� vector ����� ����������� ������ � ���������� �������'
            end
                        
            if numel( dx ) ~= 1 || ~isnumeric( dx ) || numel( dy ) ~= 1 || ~isnumeric( dy )
                error '������� ���������, ������������ ���������� ������� ����������� ���� ������� ���� ��������� ���������'
            end

            if numel( obj.xdata ) == obj.numpoint 
                obj.add_colon()
            end

            obj.xdata(obj.numpoint+1) = obj.xdata(obj.numpoint) + dx;
            obj.ydata(obj.numpoint+1) = obj.ydata(obj.numpoint) + dy;            
            obj.numpoint = obj.numpoint + 1;

            if obj.bufsize == 1
                obj.daraw_enable_at_bufsize_equal_1 = 'on';
                obj.draw();
                obj.daraw_enable_at_bufsize_equal_1 = 'off';
            end
            
        end % function vector
        
        
        
        function punct( obj, x, y )
            %punct - "����������" ���� � ����� � ��������� ������������
            %
            %���������:
            %           obj.punct( x, y )
            %����:
            % - obj = ��������� ������ ������ Pero
            % - x,y = ���������� ����� = ������� double
            %
            %����:
            % - ��������� ����� ��������� � �����, ����
            % ������������� ������ ������ ������ 1, ��� ����� �����
            % ��������� ��������������� � �������, ���� ������ ������ ����� 1 
            
            if numel( obj ) ~= 1
                error '����� punct ����� ����������� ������ � ���������� �������'
            end
            
            if numel( x ) ~= 1 || ~isnumeric( x ) || numel( y ) ~= 1 || ~isnumeric( y )
                error '������� ���������, ������������ ���������� ����� ����� ������� ���� ��������� ���������'
            end
            
            if numel( obj.xdata ) == obj.numpoint
                obj.add_colon()
            end
                        
            obj.xdata(obj.numpoint+1) =  x;
            obj.ydata(obj.numpoint+1) =  y;            
            obj.numpoint = obj.numpoint + 1;
            
            if obj.bufsize == 1
                obj.daraw_enable_at_bufsize_equal_1 = 'on';
                obj.draw();
                obj.daraw_enable_at_bufsize_equal_1 = 'off';
            end

        end % function punct
        
        
        
        function transform( obj, f, varargin )
            %transform - ��������� �������������� ��������� �����, ���������� � ������, �� ��������� ������
            %
            %���������:
            %           obj.transform( f )
            %           obj.transform( f, p1,...,pn )
            %
            %����:
            % - obj = ��������� ������ ������ Pero
            % - ���������� ������ ����������� ������ ������ 1
            % - f = ������ �� �������  ( function_handle ), ��������������
            % �������������� ������������ ��������� � ������� ��������� ����:
            %   function [ x2, y2 ] = F( x1, y1 ) 
            % ��� 
            %   function [ x2, y2 ] = F( x1, y1, p1,...,pn )
            % ��������������, ��� x1, y1 - ��������� ���������� ��������� ���������
            % (������������) ����� ���������, x2, y2 - ��������� ���������� �� ������ ���
            % ����������� F ( ��� �������-������������� ����� ���� ����� ������, �� ����, 
            % ��� � �������, ��� F, �� ������� �������� f = @F - ��� ������ �� ������� F )
            % - p1,...,pn - ����� �������������� ���������� ��� ������� f 
            % (����� �������������� ���������� � �� ���� ����� ���� ������)
            %
            %����:
            % - ���������� ���� �����, ������������ �� ���������� ������
            % obj, ������������� ��� ������ ������� f
            
            if obj.bufsize == 1
                error '����� transform �� ����� ����������� ��� ������������� ������� ������ ������ 1'
            end            
            
            if numel( obj ) ~= 1
                error '����� transform ����� ����������� ������ � ���������� �������'
            end
           
            for i = 1:obj.numpoint
                [ obj.xdata(i), obj.ydata(i) ] = f( obj.xdata(i), obj.ydata(i), varargin{:} );
            end
            
        end % function transform
        
    
    
        function disp( obj, mode )
            %disp - ���������� ������ ������ Pero � ��������� ����
            %
            %���������:
            %   obj.disp()           - ���������� ������ ������ Pero � ��������� ���� ( �������� ������ ���������� )
            %   obj.disp( 'prime' )  - ���������� ������ �������� ���������� � ������ � ��������� �������      
            %
            %����:
            % - obj = ������ ������ Pero ( �� ����������� ������ )
            % - [mode] = 'prime' - �������������� ��������-����; 
            %            � ���� ������ obj - ������ ���� ��������
            %
                        
            if nargin == 2 
                if ischar( mode ) && strcmpi( mode, 'prime' )
                    obj.disp_prime()
                    return
                else
                    error '����������������� �������� ���������'
                end
            end
            
            
            if numel( obj ) == 1
                try % for Octave 4.0
                    if isvalid( obj ) == 1
                        disp '������ ������ Pero ( < handle ):'
                        obj.disp_prime() 
                        disp ' - ������ ������: punct, vector, draw, transform, set, disp'
                     else
                        disp '������ ������' 
                     end
                 end
            else
                disp( ['������ �������� ������ Pero ������� ', num2str( size( obj, 1)), ' �� ',...
                    num2str( size( obj, 2) ), ' ( ��������� �������� ����� ���� ��� ������� )'] )
            end

        end % function disp
     
    end % methods public
  
    
    
    methods( Access = private )
        
        function disp_prime( obj )
            %disp_prime - ���������� ������ �������� ���������� � ������ � ��������� ������� 
            
            if min( size( obj ) ) ~= 1            
                error '����� ������ ���� ��������'
            end
 
            try % for Octave 4.0
              if isvalid( obj ) == 0
                  error '������ ������' 
              end
            end
            
            disp( [' - ���������� ��������� �����  = [', num2str( obj.xdata(obj.numpoint) ), ', ', num2str( obj.ydata(obj.numpoint) ),']'])
            disp( [' - ����� ���� ����� � ������   = ', num2str( obj.numpoint )])
            disp( [' - ������ ������               = ', num2str( obj.bufsize )])
           
            if ischar( obj.linecolor )
                color = ['''', obj.linecolor, ''''];
            else
                color = ['[', num2str( obj.linecolor ), ']'];
            end
            disp( [' - ���� �����      = ', color])

            if ischar( obj.patchcolor )
                color = ['''', obj.patchcolor, ''''];
            else
                color = ['[', num2str( obj.patchcolor ), ']'];
            end
            disp( [' - ���� �������    = ', color])

            disp( [' - ������� �����   = ', num2str( obj.linewidth )])
            disp( [' - ����� �����     = ''', obj.linestyle, ''''])
            disp( [' - ����� ��������  = ''', obj.marker, ''''])
            disp( [' - ������ �������� = ''', num2str( obj.markersize ), ''''])
            disp( [' - �������������� ��������� �������� = ', num2str( obj.delay )])
            
        end% function disp_prime
        
        
        
        function add_colon( obj ) 
            % ����������� ������ ������ ������ ��� �� 1 �������
            
            n = size( obj.xdata, 2 );
            obj.xdata(1, n+1) = 0;
            obj.ydata(1, n+1) = 0;
        end % function add_colon
        
    end % methods private
    
end % classdef
